/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline.valve;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import com.tongweb.commons.utils.DateUtils;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StartDateTimeValidatorValve
implements ValidatorValve {
    private static final Log log = LogFactory.getLog(StartDateTimeValidatorValve.class);

    @Override
    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        if (validationContext == null) {
            return ResponseFactory.genSuccessResult();
        }
        String instanceTimestamp = validationContext.get("instanceTimestamp");
        if (instanceTimestamp == null || instanceTimestamp.length() == 0) {
            return ResponseFactory.genSuccessResult();
        }
        String createDate = license.getCreateDate();
        if (createDate != null && createDate.length() != 0 && DateUtils.parse(createDate, "yyyy-MM-dd").after(new Date(Long.parseLong(instanceTimestamp)))) {
            log.error((Object)("The creation time of the license is illegal, creation : " + createDate));
            return ResponseFactory.genErrorCodeResult(ResultCodeEnum.CURRENT_TIME_BEFORE_CREATE, "The creation time of the license is illegal, creation : " + createDate);
        }
        return ResponseFactory.genSuccessResult();
    }
}

