/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.license.validate.pipeline.valve;

import com.tongweb.commons.license.bean.TongWebLicense;
import com.tongweb.commons.license.bean.response.Response;
import com.tongweb.commons.license.bean.response.ResponseFactory;
import com.tongweb.commons.license.bean.response.ResultCodeEnum;
import com.tongweb.commons.license.validate.pipeline.valve.ValidatorValve;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionNumberValidatorValve
implements ValidatorValve {
    private static final Log log = LogFactory.getLog(VersionNumberValidatorValve.class);

    @Override
    public Response validate(TongWebLicense license, Map<String, String> validationContext) {
        if (validationContext == null) {
            return ResponseFactory.genSuccessResult();
        }
        String productVersion = validationContext.get("productVersion");
        if (productVersion == null || productVersion.length() == 0) {
            return ResponseFactory.genSuccessResult();
        }
        if (productVersion.toUpperCase().startsWith(license.getTongWebVersion().toUpperCase()) && productVersion.length() >= 5) {
            return ResponseFactory.genSuccessResult();
        }
        log.fatal((Object)("License is not for this edition of product, License version is : " + license.getTongWebVersion()));
        return ResponseFactory.genErrorCodeResult(ResultCodeEnum.EDITION_NO_MATCH, "License is not for this edition of product, License version is : " + license.getTongWebVersion());
    }
}

