/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.facade;

import com.tongweb.commons.logger.facade.IMarkerFactory;
import com.tongweb.commons.logger.facade.Marker;
import com.tongweb.commons.logger.facade.helpers.BasicMarkerFactory;
import com.tongweb.commons.logger.facade.helpers.Util;
import com.tongweb.commons.logger.facade.impl.StaticMarkerBinder;

public class MarkerFactory {
    static IMarkerFactory MARKER_FACTORY;

    private MarkerFactory() {
    }

    private static IMarkerFactory bwCompatibleGetMarkerFactoryFromBinder() throws NoClassDefFoundError {
        try {
            return StaticMarkerBinder.getSingleton().getMarkerFactory();
        }
        catch (NoSuchMethodError nsme) {
            return StaticMarkerBinder.SINGLETON.getMarkerFactory();
        }
    }

    public static Marker getMarker(String name) {
        return MARKER_FACTORY.getMarker(name);
    }

    public static Marker getDetachedMarker(String name) {
        return MARKER_FACTORY.getDetachedMarker(name);
    }

    public static IMarkerFactory getIMarkerFactory() {
        return MARKER_FACTORY;
    }

    static {
        try {
            MARKER_FACTORY = MarkerFactory.bwCompatibleGetMarkerFactoryFromBinder();
        }
        catch (NoClassDefFoundError e2) {
            MARKER_FACTORY = new BasicMarkerFactory();
        }
        catch (Exception e3) {
            Util.report("Unexpected failure while binding MarkerFactory", e3);
        }
    }
}

