/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.facade.impl;

import com.tongweb.commons.logger.facade.ILoggerFactory;
import com.tongweb.commons.logger.facade.helpers.Util;
import com.tongweb.commons.logger.facade.spi.LoggerFactoryBinder;
import com.tongweb.commons.logger.impl.classic.LoggerContext;
import com.tongweb.commons.logger.impl.classic.util.ContextInitializer;
import com.tongweb.commons.logger.impl.classic.util.ContextSelectorStaticBinder;
import com.tongweb.commons.logger.impl.core.status.StatusUtil;
import com.tongweb.commons.logger.impl.core.util.StatusPrinter;

public class StaticLoggerBinder
implements LoggerFactoryBinder {
    public static String REQUESTED_API_VERSION = "1.7.16";
    static final String NULL_CS_URL = "#null_CS";
    private static StaticLoggerBinder SINGLETON = new StaticLoggerBinder();
    private static final Object KEY = new Object();
    private boolean initialized = false;
    private final LoggerContext defaultLoggerContext = new LoggerContext();
    private final ContextSelectorStaticBinder contextSelectorBinder = ContextSelectorStaticBinder.getSingleton();

    private StaticLoggerBinder() {
        this.defaultLoggerContext.setName("default");
    }

    public static StaticLoggerBinder getSingleton() {
        return SINGLETON;
    }

    static void reset() {
        SINGLETON = new StaticLoggerBinder();
        SINGLETON.init();
    }

    void init() {
        try {
            try {
                new ContextInitializer(this.defaultLoggerContext).autoConfig();
            }
            catch (Exception je) {
                Util.report("Failed to auto configure default logger context", je);
            }
            if (!StatusUtil.contextHasStatusListener(this.defaultLoggerContext)) {
                StatusPrinter.printInCaseOfErrorsOrWarnings(this.defaultLoggerContext);
            }
            this.contextSelectorBinder.init(this.defaultLoggerContext, KEY);
            this.initialized = true;
        }
        catch (Exception t) {
            Util.report("Failed to instantiate [" + LoggerContext.class.getName() + "]", t);
        }
    }

    @Override
    public ILoggerFactory getLoggerFactory() {
        if (!this.initialized) {
            return this.defaultLoggerContext;
        }
        if (this.contextSelectorBinder.getContextSelector() == null) {
            throw new IllegalStateException("contextSelector cannot be null. See also #null_CS");
        }
        return this.contextSelectorBinder.getContextSelector().getLoggerContext();
    }

    @Override
    public String getLoggerFactoryClassStr() {
        return this.contextSelectorBinder.getClass().getName();
    }

    static {
        SINGLETON.init();
    }
}

