/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.filter;

import com.tongweb.commons.logger.impl.classic.Level;
import com.tongweb.commons.logger.impl.classic.spi.ILoggingEvent;
import com.tongweb.commons.logger.impl.core.filter.Filter;
import com.tongweb.commons.logger.impl.core.spi.FilterReply;

public class ThresholdFilter
extends Filter<ILoggingEvent> {
    Level level;

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        if (event.getLevel().isGreaterOrEqual(this.level)) {
            return FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public void setLevel(String level) {
        this.level = Level.toLevel(level);
    }

    @Override
    public void start() {
        if (this.level != null) {
            super.start();
        }
    }
}

