/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.joran.action;

import com.tongweb.commons.logger.impl.classic.Logger;
import com.tongweb.commons.logger.impl.classic.LoggerContext;
import com.tongweb.commons.logger.impl.classic.net.SocketAppender;
import com.tongweb.commons.logger.impl.core.joran.action.Action;
import com.tongweb.commons.logger.impl.core.joran.spi.ActionException;
import com.tongweb.commons.logger.impl.core.joran.spi.InterpretationContext;
import org.xml.sax.Attributes;

public class ConsolePluginAction
extends Action {
    private static final String PORT_ATTR = "port";
    private static final Integer DEFAULT_PORT = 4321;

    @Override
    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        String portStr = attributes.getValue(PORT_ATTR);
        Integer port = null;
        if (portStr == null) {
            port = DEFAULT_PORT;
        } else {
            try {
                port = Integer.valueOf(portStr);
            }
            catch (NumberFormatException ex) {
                this.addError("Port " + portStr + " in ConsolePlugin config is not a correct number");
            }
        }
        LoggerContext lc = (LoggerContext)ec.getContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext(lc);
        appender.setIncludeCallerData(true);
        appender.setRemoteHost("localhost");
        appender.setPort(port);
        appender.start();
        Logger root = lc.getLogger("ROOT");
        root.addAppender(appender);
        this.addInfo("Sending LoggingEvents to the plugin using port " + port);
    }

    @Override
    public void end(InterpretationContext ec, String name) throws ActionException {
    }
}

