/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.joran.action;

import com.tongweb.commons.logger.impl.classic.LoggerContext;
import com.tongweb.commons.logger.impl.classic.spi.LoggerContextListener;
import com.tongweb.commons.logger.impl.core.joran.action.Action;
import com.tongweb.commons.logger.impl.core.joran.spi.ActionException;
import com.tongweb.commons.logger.impl.core.joran.spi.InterpretationContext;
import com.tongweb.commons.logger.impl.core.spi.ContextAware;
import com.tongweb.commons.logger.impl.core.spi.LifeCycle;
import com.tongweb.commons.logger.impl.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class LoggerContextListenerAction
extends Action {
    boolean inError = false;
    LoggerContextListener lcl;

    @Override
    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        this.inError = false;
        String className = attributes.getValue("class");
        if (OptionHelper.isEmpty(className)) {
            this.addError("Mandatory \"class\" attribute not set for <loggerContextListener> element");
            this.inError = true;
            return;
        }
        try {
            this.lcl = (LoggerContextListener)OptionHelper.instantiateByClassName(className, LoggerContextListener.class, this.context);
            if (this.lcl instanceof ContextAware) {
                ((ContextAware)((Object)this.lcl)).setContext(this.context);
            }
            ec.pushObject(this.lcl);
            this.addInfo("Adding LoggerContextListener of type [" + className + "] to the object stack");
        }
        catch (Exception oops) {
            this.inError = true;
            this.addError("Could not create LoggerContextListener of type " + className + "].", oops);
        }
    }

    @Override
    public void end(InterpretationContext ec, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Object o = ec.peekObject();
        if (o != this.lcl) {
            this.addWarn("The object on the top the of the stack is not the LoggerContextListener pushed earlier.");
        } else {
            if (this.lcl instanceof LifeCycle) {
                ((LifeCycle)((Object)this.lcl)).start();
                this.addInfo("Starting LoggerContextListener");
            }
            ((LoggerContext)this.context).addListener(this.lcl);
            ec.popObject();
        }
    }
}

