/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.joran.action;

import com.tongweb.commons.logger.impl.classic.Level;
import com.tongweb.commons.logger.impl.classic.Logger;
import com.tongweb.commons.logger.impl.classic.LoggerContext;
import com.tongweb.commons.logger.impl.core.joran.action.Action;
import com.tongweb.commons.logger.impl.core.joran.spi.InterpretationContext;
import com.tongweb.commons.logger.impl.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class RootLoggerAction
extends Action {
    Logger root;
    boolean inError = false;

    @Override
    public void begin(InterpretationContext ec, String name, Attributes attributes) {
        this.inError = false;
        LoggerContext loggerContext = (LoggerContext)this.context;
        this.root = loggerContext.getLogger("ROOT");
        String levelStr = ec.subst(attributes.getValue("level"));
        if (!OptionHelper.isEmpty(levelStr)) {
            Level level = Level.toLevel(levelStr);
            this.addInfo("Setting level of ROOT logger to " + level);
            this.root.setLevel(level);
        }
        ec.pushObject(this.root);
    }

    @Override
    public void end(InterpretationContext ec, String name) {
        if (this.inError) {
            return;
        }
        Object o = ec.peekObject();
        if (o != this.root) {
            this.addWarn("The object on the top the of the stack is not the root logger");
            this.addWarn("It is: " + o);
        } else {
            ec.popObject();
        }
    }

    public void finish(InterpretationContext ec) {
    }
}

