/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.layout;

import com.tongweb.commons.logger.impl.classic.pattern.ThrowableProxyConverter;
import com.tongweb.commons.logger.impl.classic.spi.ILoggingEvent;
import com.tongweb.commons.logger.impl.classic.spi.IThrowableProxy;
import com.tongweb.commons.logger.impl.core.CoreConstants;
import com.tongweb.commons.logger.impl.core.LayoutBase;
import com.tongweb.commons.logger.impl.core.util.CachingDateFormatter;

public class TTLLLayout
extends LayoutBase<ILoggingEvent> {
    CachingDateFormatter cachingDateFormatter = new CachingDateFormatter("HH:mm:ss.SSS");
    ThrowableProxyConverter tpc = new ThrowableProxyConverter();

    @Override
    public void start() {
        this.tpc.start();
        super.start();
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        if (!this.isStarted()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long timestamp = event.getTimeStamp();
        sb.append(this.cachingDateFormatter.format(timestamp));
        sb.append(" [");
        sb.append(event.getThreadName());
        sb.append("] ");
        sb.append(event.getLevel().toString());
        sb.append(" ");
        sb.append(event.getLoggerName());
        sb.append(" - ");
        sb.append(event.getFormattedMessage());
        sb.append(CoreConstants.LINE_SEPARATOR);
        IThrowableProxy tp = event.getThrowableProxy();
        if (tp != null) {
            String stackTrace = this.tpc.convert(event);
            sb.append(stackTrace);
        }
        return sb.toString();
    }
}

