/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.net;

import com.tongweb.commons.logger.impl.classic.net.SocketReceiver;
import com.tongweb.commons.logger.impl.core.net.ssl.ConfigurableSSLSocketFactory;
import com.tongweb.commons.logger.impl.core.net.ssl.SSLComponent;
import com.tongweb.commons.logger.impl.core.net.ssl.SSLConfiguration;
import com.tongweb.commons.logger.impl.core.net.ssl.SSLParametersConfiguration;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;

public class SSLSocketReceiver
extends SocketReceiver
implements SSLComponent {
    private SSLConfiguration ssl;
    private SocketFactory socketFactory;

    @Override
    protected SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    @Override
    protected boolean shouldStart() {
        try {
            SSLContext sslContext = this.getSsl().createContext(this);
            SSLParametersConfiguration parameters = this.getSsl().getParameters();
            parameters.setContext(this.getContext());
            this.socketFactory = new ConfigurableSSLSocketFactory(parameters, sslContext.getSocketFactory());
            return super.shouldStart();
        }
        catch (Exception ex) {
            this.addError(ex.getMessage(), ex);
            return false;
        }
    }

    @Override
    public SSLConfiguration getSsl() {
        if (this.ssl == null) {
            this.ssl = new SSLConfiguration();
        }
        return this.ssl;
    }

    @Override
    public void setSsl(SSLConfiguration ssl) {
        this.ssl = ssl;
    }
}

