/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.net;

import com.tongweb.commons.logger.impl.classic.LoggerContext;
import com.tongweb.commons.logger.impl.classic.net.SimpleSocketServer;
import com.tongweb.commons.logger.impl.core.net.ssl.ConfigurableSSLServerSocketFactory;
import com.tongweb.commons.logger.impl.core.net.ssl.SSLParametersConfiguration;
import java.security.NoSuchAlgorithmException;
import javax.net.ServerSocketFactory;
import javax.net.ssl.SSLContext;

public class SimpleSSLSocketServer
extends SimpleSocketServer {
    private final ServerSocketFactory socketFactory;

    public static void main(String[] argv) throws Exception {
        SimpleSSLSocketServer.doMain(SimpleSSLSocketServer.class, argv);
    }

    public SimpleSSLSocketServer(LoggerContext lc, int port) throws NoSuchAlgorithmException {
        this(lc, port, SSLContext.getDefault());
    }

    public SimpleSSLSocketServer(LoggerContext lc, int port, SSLContext sslContext) {
        super(lc, port);
        if (sslContext == null) {
            throw new NullPointerException("SSL context required");
        }
        SSLParametersConfiguration parameters = new SSLParametersConfiguration();
        parameters.setContext(lc);
        this.socketFactory = new ConfigurableSSLServerSocketFactory(parameters, sslContext.getServerSocketFactory());
    }

    @Override
    protected ServerSocketFactory getServerSocketFactory() {
        return this.socketFactory;
    }
}

