/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.pattern;

import com.tongweb.commons.logger.impl.classic.pattern.ClassicConverter;
import com.tongweb.commons.logger.impl.classic.spi.ILoggingEvent;
import com.tongweb.commons.logger.impl.core.util.CachingDateFormatter;
import java.util.List;
import java.util.TimeZone;

public class DateConverter
extends ClassicConverter {
    long lastTimestamp = -1L;
    String timestampStrCache = null;
    CachingDateFormatter cachingDateFormatter = null;

    @Override
    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.cachingDateFormatter = new CachingDateFormatter(datePattern);
        }
        catch (IllegalArgumentException e2) {
            this.addWarn("Could not instantiate SimpleDateFormat with pattern " + datePattern, e2);
            this.cachingDateFormatter = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss,SSS");
        }
        List<String> optionList = this.getOptionList();
        if (optionList != null && optionList.size() > 1) {
            TimeZone tz = TimeZone.getTimeZone(optionList.get(1));
            this.cachingDateFormatter.setTimeZone(tz);
        }
    }

    @Override
    public String convert(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        return this.cachingDateFormatter.format(timestamp);
    }
}

