/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.pattern;

import com.tongweb.commons.logger.impl.classic.pattern.Abbreviator;
import com.tongweb.commons.logger.impl.classic.pattern.ClassNameOnlyAbbreviator;
import com.tongweb.commons.logger.impl.classic.pattern.ClassicConverter;
import com.tongweb.commons.logger.impl.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import com.tongweb.commons.logger.impl.classic.spi.ILoggingEvent;

public abstract class NamedConverter
extends ClassicConverter {
    Abbreviator abbreviator = null;

    protected abstract String getFullyQualifiedName(ILoggingEvent var1);

    @Override
    public void start() {
        String optStr = this.getFirstOption();
        if (optStr != null) {
            try {
                int targetLen = Integer.parseInt(optStr);
                if (targetLen == 0) {
                    this.abbreviator = new ClassNameOnlyAbbreviator();
                } else if (targetLen > 0) {
                    this.abbreviator = new TargetLengthBasedClassNameAbbreviator(targetLen);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public String convert(ILoggingEvent event) {
        String fqn = this.getFullyQualifiedName(event);
        if (this.abbreviator == null) {
            return fqn;
        }
        return this.abbreviator.abbreviate(fqn);
    }
}

