/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.selector.servlet;

import com.tongweb.commons.logger.impl.classic.Logger;
import com.tongweb.commons.logger.impl.classic.LoggerContext;
import com.tongweb.commons.logger.impl.classic.selector.ContextSelector;
import com.tongweb.commons.logger.impl.classic.util.ContextSelectorStaticBinder;
import com.tongweb.commons.logger.impl.classic.util.JNDIUtil;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class ContextDetachingSCL
implements ServletContextListener {
    @Override
    public void contextInitialized(ServletContextEvent arg0) {
    }

    @Override
    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        String loggerContextName = null;
        try {
            Context ctx = JNDIUtil.getInitialContext();
            loggerContextName = JNDIUtil.lookup(ctx, "java:comp/env/logback/context-name");
        }
        catch (NamingException ctx) {
            // empty catch block
        }
        if (loggerContextName != null) {
            System.out.println("About to detach context named " + loggerContextName);
            ContextSelector selector = ContextSelectorStaticBinder.getSingleton().getContextSelector();
            if (selector == null) {
                System.out.println("Selector is null, cannot detach context. Skipping.");
                return;
            }
            LoggerContext context = selector.getLoggerContext(loggerContextName);
            if (context != null) {
                Logger logger = context.getLogger("ROOT");
                logger.warn("Stopping logger context " + loggerContextName);
                selector.detachLoggerContext(loggerContextName);
                context.stop();
            } else {
                System.out.println("No context named " + loggerContextName + " was found.");
            }
        }
    }
}

