/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.classic.spi;

import com.tongweb.commons.logger.facade.Marker;
import com.tongweb.commons.logger.impl.classic.Level;
import com.tongweb.commons.logger.impl.classic.Logger;
import com.tongweb.commons.logger.impl.classic.turbo.TurboFilter;
import com.tongweb.commons.logger.impl.core.spi.FilterReply;
import java.util.concurrent.CopyOnWriteArrayList;

public final class TurboFilterList
extends CopyOnWriteArrayList<TurboFilter> {
    private static final long serialVersionUID = 1L;

    public FilterReply getTurboFilterChainDecision(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
        int size = this.size();
        if (size == 1) {
            try {
                TurboFilter tf = (TurboFilter)this.get(0);
                return tf.decide(marker, logger, level, format, params, t);
            }
            catch (IndexOutOfBoundsException iobe) {
                return FilterReply.NEUTRAL;
            }
        }
        Object[] tfa = this.toArray();
        int len = tfa.length;
        for (int i2 = 0; i2 < len; ++i2) {
            TurboFilter tf = (TurboFilter)tfa[i2];
            FilterReply r = tf.decide(marker, logger, level, format, params, t);
            if (r != FilterReply.DENY && r != FilterReply.ACCEPT) continue;
            return r;
        }
        return FilterReply.NEUTRAL;
    }
}

