/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.filter;

import com.tongweb.commons.logger.impl.core.boolex.EvaluationException;
import com.tongweb.commons.logger.impl.core.boolex.EventEvaluator;
import com.tongweb.commons.logger.impl.core.filter.AbstractMatcherFilter;
import com.tongweb.commons.logger.impl.core.spi.FilterReply;

public class EvaluatorFilter<E>
extends AbstractMatcherFilter<E> {
    EventEvaluator<E> evaluator;

    @Override
    public void start() {
        if (this.evaluator != null) {
            super.start();
        } else {
            this.addError("No evaluator set for filter " + this.getName());
        }
    }

    public EventEvaluator<E> getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(EventEvaluator<E> evaluator) {
        this.evaluator = evaluator;
    }

    @Override
    public FilterReply decide(E event) {
        if (!this.isStarted() || !this.evaluator.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        try {
            if (this.evaluator.evaluate(event)) {
                return this.onMatch;
            }
            return this.onMismatch;
        }
        catch (EvaluationException e2) {
            this.addError("Evaluator " + this.evaluator.getName() + " threw an exception", e2);
            return FilterReply.NEUTRAL;
        }
    }
}

