/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.joran.action;

import com.tongweb.commons.logger.impl.core.joran.action.Action;
import com.tongweb.commons.logger.impl.core.joran.spi.ActionException;
import com.tongweb.commons.logger.impl.core.joran.spi.InterpretationContext;
import com.tongweb.commons.logger.impl.core.spi.ContextAware;
import com.tongweb.commons.logger.impl.core.spi.LifeCycle;
import com.tongweb.commons.logger.impl.core.status.StatusListener;
import com.tongweb.commons.logger.impl.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class StatusListenerAction
extends Action {
    boolean inError = false;
    Boolean effectivelyAdded = null;
    StatusListener statusListener = null;

    @Override
    public void begin(InterpretationContext ec, String name, Attributes attributes) throws ActionException {
        this.inError = false;
        this.effectivelyAdded = null;
        String className = attributes.getValue("class");
        if (OptionHelper.isEmpty(className)) {
            this.addError("Missing class name for statusListener. Near [" + name + "] line " + this.getLineNumber(ec));
            this.inError = true;
            return;
        }
        try {
            this.statusListener = (StatusListener)OptionHelper.instantiateByClassName(className, StatusListener.class, this.context);
            this.effectivelyAdded = ec.getContext().getStatusManager().add(this.statusListener);
            if (this.statusListener instanceof ContextAware) {
                ((ContextAware)((Object)this.statusListener)).setContext(this.context);
            }
            this.addInfo("Added status listener of type [" + className + "]");
            ec.pushObject(this.statusListener);
        }
        catch (Exception e2) {
            this.inError = true;
            this.addError("Could not create an StatusListener of type [" + className + "].", e2);
            throw new ActionException(e2);
        }
    }

    public void finish(InterpretationContext ec) {
    }

    @Override
    public void end(InterpretationContext ec, String e2) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.isEffectivelyAdded() && this.statusListener instanceof LifeCycle) {
            ((LifeCycle)((Object)this.statusListener)).start();
        }
        if ((o = ec.peekObject()) != this.statusListener) {
            this.addWarn("The object at the of the stack is not the statusListener pushed earlier.");
        } else {
            ec.popObject();
        }
    }

    private boolean isEffectivelyAdded() {
        if (this.effectivelyAdded == null) {
            return false;
        }
        return this.effectivelyAdded;
    }
}

