/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.pattern;

import com.tongweb.commons.logger.impl.core.pattern.Converter;
import com.tongweb.commons.logger.impl.core.pattern.DynamicConverter;

public abstract class CompositeConverter<E>
extends DynamicConverter<E> {
    Converter<E> childConverter;

    @Override
    public String convert(E event) {
        StringBuilder buf = new StringBuilder();
        Converter<E> c2 = this.childConverter;
        while (c2 != null) {
            c2.write(buf, event);
            c2 = c2.next;
        }
        String intermediary = buf.toString();
        return this.transform(event, intermediary);
    }

    protected abstract String transform(E var1, String var2);

    public Converter<E> getChildConverter() {
        return this.childConverter;
    }

    public void setChildConverter(Converter<E> child) {
        this.childConverter = child;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("CompositeConverter<");
        if (this.formattingInfo != null) {
            buf.append(this.formattingInfo);
        }
        if (this.childConverter != null) {
            buf.append(", children: ").append(this.childConverter);
        }
        buf.append(">");
        return buf.toString();
    }
}

