/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.pattern;

import com.tongweb.commons.logger.impl.core.Context;
import com.tongweb.commons.logger.impl.core.pattern.CompositeConverter;
import com.tongweb.commons.logger.impl.core.pattern.Converter;
import com.tongweb.commons.logger.impl.core.pattern.DynamicConverter;
import com.tongweb.commons.logger.impl.core.spi.ContextAware;

public class ConverterUtil {
    public static <E> void startConverters(Converter<E> head) {
        for (Converter<E> c2 = head; c2 != null; c2 = c2.getNext()) {
            if (c2 instanceof CompositeConverter) {
                CompositeConverter cc = (CompositeConverter)c2;
                Converter childConverter = cc.childConverter;
                ConverterUtil.startConverters(childConverter);
                cc.start();
                continue;
            }
            if (!(c2 instanceof DynamicConverter)) continue;
            DynamicConverter dc = (DynamicConverter)c2;
            dc.start();
        }
    }

    public static <E> Converter<E> findTail(Converter<E> head) {
        Converter<E> next;
        Converter<E> p = head;
        while (p != null && (next = p.getNext()) != null) {
            p = next;
        }
        return p;
    }

    public static <E> void setContextForConverters(Context context, Converter<E> head) {
        for (Converter<E> c2 = head; c2 != null; c2 = c2.getNext()) {
            if (!(c2 instanceof ContextAware)) continue;
            ((ContextAware)((Object)c2)).setContext(context);
        }
    }
}

