/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.rolling;

import com.tongweb.commons.logger.impl.core.FileAppender;
import com.tongweb.commons.logger.impl.core.rolling.RollingPolicy;
import com.tongweb.commons.logger.impl.core.rolling.helper.CompressionMode;
import com.tongweb.commons.logger.impl.core.rolling.helper.FileNamePattern;
import com.tongweb.commons.logger.impl.core.spi.ContextAwareBase;

public abstract class RollingPolicyBase
extends ContextAwareBase
implements RollingPolicy {
    protected CompressionMode compressionMode = CompressionMode.NONE;
    protected FileNamePattern fileNamePattern;
    protected String fileNamePatternStr;
    protected FileAppender<?> parent;
    protected FileNamePattern zipEntryFileNamePattern;
    protected boolean started;

    protected void determineCompressionMode() {
        if (this.fileNamePatternStr.endsWith(".gz")) {
            this.addInfo("Will use gz compression");
            this.compressionMode = CompressionMode.GZ;
        } else if (this.fileNamePatternStr.endsWith(".zip")) {
            this.addInfo("Will use zip compression");
            this.compressionMode = CompressionMode.ZIP;
        } else {
            this.addInfo("No compression will be used");
            this.compressionMode = CompressionMode.NONE;
        }
    }

    public void setFileNamePattern(String fnp) {
        this.fileNamePatternStr = fnp;
    }

    public String getFileNamePattern() {
        return this.fileNamePatternStr;
    }

    @Override
    public CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void stop() {
        this.started = false;
    }

    @Override
    public void setParent(FileAppender<?> appender) {
        this.parent = appender;
    }

    public boolean isParentPrudent() {
        return this.parent.isPrudent();
    }

    public String getParentsRawFileProperty() {
        return this.parent.rawFileProperty();
    }
}

