/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.rolling.helper;

import com.tongweb.commons.logger.impl.core.rolling.helper.FileFilterUtil;
import com.tongweb.commons.logger.impl.core.rolling.helper.FileNamePattern;
import com.tongweb.commons.logger.impl.core.rolling.helper.RollingCalendar;
import com.tongweb.commons.logger.impl.core.rolling.helper.TimeBasedArchiveRemover;
import java.io.File;
import java.util.Date;

public class SizeAndTimeBasedArchiveRemover
extends TimeBasedArchiveRemover {
    public SizeAndTimeBasedArchiveRemover(FileNamePattern fileNamePattern, RollingCalendar rc) {
        super(fileNamePattern, rc);
    }

    @Override
    protected File[] getFilesInPeriod(Date dateOfPeriodToClean) {
        File archive0 = new File(this.fileNamePattern.convertMultipleArguments(dateOfPeriodToClean, 0));
        File parentDir = this.getParentDir(archive0);
        String stemRegex = this.createStemRegex(dateOfPeriodToClean);
        File[] matchingFileArray = FileFilterUtil.filesInFolderMatchingStemRegex(parentDir, stemRegex);
        return matchingFileArray;
    }

    private String createStemRegex(Date dateOfPeriodToClean) {
        String regex = this.fileNamePattern.toRegexForFixedDate(dateOfPeriodToClean);
        return FileFilterUtil.afterLastSlash(regex);
    }
}

