/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.util;

import com.tongweb.commons.logger.impl.core.Context;
import com.tongweb.commons.logger.impl.core.spi.ContextAwareBase;

public class InterruptUtil
extends ContextAwareBase {
    final boolean previouslyInterrupted;

    public InterruptUtil(Context context) {
        this.setContext(context);
        this.previouslyInterrupted = Thread.currentThread().isInterrupted();
    }

    public void maskInterruptFlag() {
        if (this.previouslyInterrupted) {
            Thread.interrupted();
        }
    }

    public void unmaskInterruptFlag() {
        if (this.previouslyInterrupted) {
            try {
                Thread.currentThread().interrupt();
            }
            catch (SecurityException se) {
                this.addError("Failed to intrreupt current thread", se);
            }
        }
    }
}

