/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.impl.core.util;

import com.tongweb.commons.logger.impl.core.Context;
import com.tongweb.commons.logger.impl.core.spi.ContextAware;
import com.tongweb.commons.logger.impl.core.spi.LifeCycle;
import com.tongweb.commons.logger.impl.core.status.OnConsoleStatusListener;
import com.tongweb.commons.logger.impl.core.status.StatusListener;
import com.tongweb.commons.logger.impl.core.util.OptionHelper;

public class StatusListenerConfigHelper {
    public static void installIfAsked(Context context) {
        String slClass = OptionHelper.getSystemProperty("logback.statusListenerClass");
        if (!OptionHelper.isEmpty(slClass)) {
            StatusListenerConfigHelper.addStatusListener(context, slClass);
        }
    }

    private static void addStatusListener(Context context, String listenerClassName) {
        StatusListener listener = null;
        listener = "SYSOUT".equalsIgnoreCase(listenerClassName) ? new OnConsoleStatusListener() : StatusListenerConfigHelper.createListenerPerClassName(context, listenerClassName);
        StatusListenerConfigHelper.initAndAddListener(context, listener);
    }

    private static void initAndAddListener(Context context, StatusListener listener) {
        if (listener != null) {
            boolean effectivelyAdded;
            if (listener instanceof ContextAware) {
                ((ContextAware)((Object)listener)).setContext(context);
            }
            if ((effectivelyAdded = context.getStatusManager().add(listener)) && listener instanceof LifeCycle) {
                ((LifeCycle)((Object)listener)).start();
            }
        }
    }

    private static StatusListener createListenerPerClassName(Context context, String listenerClass) {
        try {
            return (StatusListener)OptionHelper.instantiateByClassName(listenerClass, StatusListener.class, context);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void addOnConsoleListenerInstance(Context context, OnConsoleStatusListener onConsoleStatusListener) {
        onConsoleStatusListener.setContext(context);
        boolean effectivelyAdded = context.getStatusManager().add(onConsoleStatusListener);
        if (effectivelyAdded) {
            onConsoleStatusListener.start();
        }
    }
}

