/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.logging;

import com.tongweb.commons.logger.logging.DirectJDKLog;
import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogConfigurationException;
import java.lang.reflect.Constructor;
import java.nio.file.FileSystems;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.logging.LogManager;

public class LogFactory {
    private static final LogFactory singleton = new LogFactory();
    private final Constructor<? extends Log> discoveredLogConstructor;

    private LogFactory() {
        FileSystems.getDefault();
        ServiceLoader<Log> logLoader = ServiceLoader.load(Log.class);
        Constructor<?> m = null;
        Iterator<Log> iterator = logLoader.iterator();
        if (iterator.hasNext()) {
            Log log = iterator.next();
            Class<?> c2 = log.getClass();
            try {
                m = c2.getConstructor(String.class);
            }
            catch (NoSuchMethodException | SecurityException e2) {
                throw new Error(e2);
            }
        }
        this.discoveredLogConstructor = m;
    }

    public Log getInstance(String name) throws LogConfigurationException {
        if (this.discoveredLogConstructor == null) {
            return DirectJDKLog.getInstance(name);
        }
        try {
            return this.discoveredLogConstructor.newInstance(name);
        }
        catch (IllegalArgumentException | ReflectiveOperationException e2) {
            throw new LogConfigurationException(e2);
        }
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return singleton;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    public static Log getLogDirectName(String name) {
        return LogFactory.getFactory().getInstance(name);
    }

    public static void release(ClassLoader classLoader) {
        if (!LogManager.getLogManager().getClass().getName().equals("java.util.logging.LogManager")) {
            LogManager.getLogManager().reset();
        }
    }
}

