/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.logger.logging;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class NameMapper {
    private static final ConcurrentHashMap<String, String> mapping = new ConcurrentHashMap();
    private static boolean moduleEnable = true;

    public static ConcurrentHashMap<String, String> getMapping() {
        return mapping;
    }

    public static boolean isModuleEnable() {
        return moduleEnable;
    }

    public static void setModuleEnable(boolean moduleEnable) {
        NameMapper.moduleEnable = moduleEnable;
    }

    public static void addMapping(String packagePattern, String moduleName) {
        mapping.put(packagePattern, moduleName);
    }

    public static void removeMapping(String packagePattern) {
        mapping.remove(packagePattern);
    }

    public static void clear() {
        mapping.clear();
    }

    public static String getModuleName(String packagePattern) {
        if (packagePattern == null || "".equals(packagePattern)) {
            return null;
        }
        if (mapping.containsKey(packagePattern)) {
            return mapping.get(packagePattern);
        }
        return mapping.keySet().stream().filter(key -> key.endsWith("*")).filter(key -> packagePattern.startsWith(key.substring(0, key.length() - 1))).findFirst().map(mapping::get).orElse("other");
    }

    public static String translateModuleName(String name) {
        if (!moduleEnable) {
            return name;
        }
        if (name.contains("-access")) {
            return name;
        }
        if (NameMapper.isModuleName(name)) {
            return name;
        }
        return NameMapper.getModuleName(name);
    }

    public static boolean isModuleName(String loggerName) {
        return mapping.containsValue(loggerName);
    }

    public static List<String> getModuleNames() {
        List<String> collect = mapping.values().stream().distinct().collect(Collectors.toList());
        if (!collect.contains("other")) {
            collect.add("other");
        }
        return collect;
    }

    public static String getMappingString() {
        return mapping.toString();
    }
}

