/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.commons.utils;

import com.tongweb.tianfu.commons.csv.ByteOrderMark;
import com.tongweb.tianfu.commons.csv.CSVFormat;
import com.tongweb.tianfu.commons.csv.CSVParser;
import com.tongweb.tianfu.commons.csv.CSVRecord;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CSVUtil {
    private static final String outFilePrefix = "deta_recovery_";

    public static byte[] writeDataAfterToBytes(String[] tableHeaderArr, List<String> cellList) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
            bufferedWriter = new BufferedWriter(outputStreamWriter);
            bufferedWriter.write(new String(ByteOrderMark.UTF_8.getBytes()));
            StringBuilder sb = new StringBuilder();
            String tableHeader = String.join((CharSequence)",", tableHeaderArr);
            sb.append(tableHeader + "\r" + "\n");
            for (String rowCell : cellList) {
                sb.append(rowCell + "\r" + "\n");
            }
            bufferedWriter.write(sb.toString());
            bufferedWriter.flush();
            byte[] bytes = byteArrayOutputStream.toString(StandardCharsets.UTF_8.name()).getBytes();
            Object object = bytes;
            return object;
        }
        catch (IOException e2) {
            throw new RuntimeException("writeDataAfterToBytes IOException:" + e2.getMessage());
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (IOException e3) {
                throw new IOException("iostream close IOException:" + e3.getMessage(), e3);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exportCSV(String[] titles, List<String> dataList, String savePath) {
        FileOutputStream fileOutputStream = null;
        try {
            byte[] bytes = CSVUtil.writeDataAfterToBytes(titles, dataList);
            fileOutputStream = new FileOutputStream(savePath + File.separator + new Date().getTime() + ".csv");
            fileOutputStream.write(bytes);
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
        return false;
    }

    public static List getRows(String savePath, String[] rowTitles) throws Exception {
        ArrayList rows = new ArrayList();
        FileReader reader = new FileReader(savePath);
        CSVParser records = CSVFormat.EXCEL.withHeader(rowTitles).parse(reader);
        Iterator iterator = records.iterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            CSVRecord record = (CSVRecord)iterator.next();
            HashMap<String, String> row = new HashMap<String, String>();
            for (String rowTitle : rowTitles) {
                row.put(rowTitle, record.get(rowTitle));
            }
            rows.add(row);
        }
        ((Reader)reader).close();
        return rows;
    }

    public static void updateCSV(String[] titles, String inPath, String outPath, Map<Integer, Map<String, String>> targets) throws Exception {
        HashMap<String, Integer> titleMap = new HashMap<String, Integer>();
        for (int i2 = 0; i2 < titles.length; ++i2) {
            titleMap.put(titles[i2], i2);
        }
        String inString = "";
        if (outPath.endsWith(File.separator) || outPath.endsWith("//")) {
            throw new Exception("the path does not exist or is illegal\uff1a" + outPath);
        }
        BufferedReader reader = new BufferedReader(new FileReader(new File(inPath)));
        BufferedWriter writer = new BufferedWriter(new FileWriter(new File(outPath)));
        int indexRow = 0;
        while ((inString = reader.readLine()) != null) {
            String[] row = inString.split(",");
            if (targets.containsKey(indexRow)) {
                Set<String> keySet = targets.get(indexRow).keySet();
                for (String key : keySet) {
                    row[((Integer)titleMap.get((Object)key)).intValue()] = targets.get(indexRow).get(key);
                }
            }
            for (int i3 = 0; i3 < row.length; ++i3) {
                writer.write(row[i3].toString() + ",");
                if (i3 != row.length - 1) continue;
                writer.newLine();
            }
            ++indexRow;
        }
        reader.close();
        writer.close();
    }
}

