/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http11.upgrade;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.connector.UpgradeToken;
import com.tongweb.connector.http11.upgrade.UpgradeGroupInfo;
import com.tongweb.connector.http11.upgrade.UpgradeInfo;
import com.tongweb.connector.http11.upgrade.UpgradeProcessorBase;
import com.tongweb.connector.http11.upgrade.UpgradeServletInputStream;
import com.tongweb.connector.http11.upgrade.UpgradeServletOutputStream;
import com.tongweb.web.util.net.AbstractEndpoint;
import com.tongweb.web.util.net.SSLSupport;
import com.tongweb.web.util.net.SocketEvent;
import com.tongweb.web.util.net.SocketWrapperBase;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;

public class UpgradeProcessorExternal
extends UpgradeProcessorBase {
    private static final Log log = LogFactory.getLog(UpgradeProcessorExternal.class);
    private static final StringManager sm = StringManager.getManager(UpgradeProcessorExternal.class);
    private final UpgradeServletInputStream upgradeServletInputStream;
    private final UpgradeServletOutputStream upgradeServletOutputStream;
    private final UpgradeInfo upgradeInfo = new UpgradeInfo();

    public UpgradeProcessorExternal(SocketWrapperBase<?> wrapper, UpgradeToken upgradeToken, UpgradeGroupInfo upgradeGroupInfo) {
        super(upgradeToken);
        upgradeGroupInfo.addUpgradeInfo(this.upgradeInfo);
        this.upgradeServletInputStream = new UpgradeServletInputStream(this, wrapper, this.upgradeInfo);
        this.upgradeServletOutputStream = new UpgradeServletOutputStream(this, wrapper, this.upgradeInfo);
        wrapper.setReadTimeout(-1L);
        wrapper.setWriteTimeout(-1L);
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public void close() throws Exception {
        this.upgradeServletInputStream.close();
        this.upgradeServletOutputStream.close();
        this.upgradeInfo.setGroupInfo(null);
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        return this.upgradeServletInputStream;
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return this.upgradeServletOutputStream;
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState dispatch(SocketEvent status) {
        if (status == SocketEvent.OPEN_READ) {
            this.upgradeServletInputStream.onDataAvailable();
        } else if (status == SocketEvent.OPEN_WRITE) {
            this.upgradeServletOutputStream.onWritePossible();
        } else {
            if (status == SocketEvent.STOP) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("upgradeProcessor.stop"));
                }
                try {
                    this.upgradeServletInputStream.close();
                }
                catch (IOException ioe) {
                    log.debug(sm.getString("upgradeProcessor.isCloseFail", ioe));
                }
                try {
                    this.upgradeServletOutputStream.close();
                }
                catch (IOException ioe) {
                    log.debug(sm.getString("upgradeProcessor.osCloseFail", ioe));
                }
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("upgradeProcessor.unexpectedState"));
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.upgradeServletInputStream.isClosed() && this.upgradeServletOutputStream.isClosed()) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("upgradeProcessor.requiredClose", this.upgradeServletInputStream.isClosed(), this.upgradeServletOutputStream.isClosed()));
            }
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.UPGRADED;
    }

    @Override
    public final void setSslSupport(SSLSupport sslSupport) {
    }

    @Override
    public void pause() {
    }
}

