/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.connector.http2;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.connector.ActionCode;
import com.tongweb.connector.Response;
import com.tongweb.connector.http2.Stream;
import com.tongweb.web.util.res.StringManager;

class WindowAllocationManager {
    private static final Log log = LogFactory.getLog(WindowAllocationManager.class);
    private static final StringManager sm = StringManager.getManager(WindowAllocationManager.class);
    private static final int NONE = 0;
    private static final int STREAM = 1;
    private static final int CONNECTION = 2;
    private final Stream stream;
    private int waitingFor = 0;

    WindowAllocationManager(Stream stream) {
        this.stream = stream;
    }

    void waitForStream(long timeout) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("windowAllocationManager.waitFor.stream", this.stream.getConnectionId(), this.stream.getIdAsString(), Long.toString(timeout)));
        }
        this.waitFor(1, timeout);
    }

    void waitForConnection(long timeout) throws InterruptedException {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("windowAllocationManager.waitFor.connection", this.stream.getConnectionId(), this.stream.getIdAsString(), Integer.toString(this.stream.getConnectionAllocationRequested()), Long.toString(timeout)));
        }
        this.waitFor(2, timeout);
    }

    void waitForStreamNonBlocking() {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("windowAllocationManager.waitForNonBlocking.stream", this.stream.getConnectionId(), this.stream.getIdAsString()));
        }
        this.waitForNonBlocking(1);
    }

    void waitForConnectionNonBlocking() {
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("windowAllocationManager.waitForNonBlocking.connection", this.stream.getConnectionId(), this.stream.getIdAsString()));
        }
        this.waitForNonBlocking(2);
    }

    void notifyStream() {
        this.notify(1);
    }

    void notifyConnection() {
        this.notify(2);
    }

    void notifyAny() {
        this.notify(3);
    }

    boolean isWaitingForStream() {
        return this.isWaitingFor(1);
    }

    boolean isWaitingForConnection() {
        return this.isWaitingFor(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isWaitingFor(int waitTarget) {
        Stream stream = this.stream;
        synchronized (stream) {
            return (this.waitingFor & waitTarget) > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitFor(int waitTarget, long timeout) throws InterruptedException {
        Stream stream = this.stream;
        synchronized (stream) {
            if (this.waitingFor != 0) {
                throw new IllegalStateException(sm.getString("windowAllocationManager.waitFor.ise", this.stream.getConnectionId(), this.stream.getIdAsString()));
            }
            this.waitingFor = waitTarget;
            if (timeout < 0L) {
                this.stream.wait();
            } else {
                this.stream.wait(timeout);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForNonBlocking(int waitTarget) {
        Stream stream = this.stream;
        synchronized (stream) {
            if (this.waitingFor == 0) {
                this.waitingFor = waitTarget;
            } else if (this.waitingFor != waitTarget) {
                throw new IllegalStateException(sm.getString("windowAllocationManager.waitFor.ise", this.stream.getConnectionId(), this.stream.getIdAsString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify(int notifyTarget) {
        Stream stream = this.stream;
        synchronized (stream) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("windowAllocationManager.notify", this.stream.getConnectionId(), this.stream.getIdAsString(), Integer.toString(this.waitingFor), Integer.toString(notifyTarget)));
            }
            if ((notifyTarget & this.waitingFor) > 0) {
                this.waitingFor = 0;
                Response response = this.stream.getCoyoteResponse();
                if (response != null) {
                    if (response.getWriteListener() == null) {
                        if (log.isDebugEnabled()) {
                            log.debug(sm.getString("windowAllocationManager.notified", this.stream.getConnectionId(), this.stream.getIdAsString()));
                        }
                        this.stream.notify();
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug(sm.getString("windowAllocationManager.dispatched", this.stream.getConnectionId(), this.stream.getIdAsString()));
                        }
                        response.action(ActionCode.DISPATCH_WRITE, null);
                        response.action(ActionCode.DISPATCH_EXECUTE, null);
                    }
                }
            }
        }
    }
}

