/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ant;

import com.tongweb.container.Globals;
import com.tongweb.container.ant.BaseRedirectorHelperTask;
import com.tongweb.web.util.descriptor.DigesterFactory;
import com.tongweb.web.util.digester.Digester;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import org.apache.tools.ant.BuildException;
import org.xml.sax.InputSource;

public class ValidatorTask
extends BaseRedirectorHelperTask {
    protected String path = null;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.path == null) {
            throw new BuildException("Must specify 'path'");
        }
        File file = new File(this.path, "WEB-INF/web.xml");
        if (!file.canRead()) {
            throw new BuildException("Cannot find web.xml");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ValidatorTask.class.getClassLoader());
        Digester digester = DigesterFactory.newDigester(true, true, null, Globals.IS_SECURITY_ENABLED);
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file.getCanonicalFile()));){
            InputSource is = new InputSource(file.toURI().toURL().toExternalForm());
            is.setByteStream(stream);
            digester.parse(is);
            this.handleOutput("web.xml validated");
        }
        catch (Exception e2) {
            if (this.isFailOnError()) {
                throw new BuildException("Validation failure", (Throwable)e2);
            }
            this.handleErrorOutput("Validation failure: " + e2);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            this.closeRedirector();
        }
    }
}

