/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.core;

import com.tongweb.commons.license.DynamicLoadingListener;
import com.tongweb.commons.license.LicenseProviderFacade;
import com.tongweb.commons.license.bean.cfg.LicenseRemoteConfig;
import com.tongweb.commons.utils.StringUtils;
import com.tongweb.container.util.ServerInfo;

public class LicenseServerSDKProvider {
    private static String validType = System.getProperty("server.tongweb.license.type");
    private static String productVersion = ServerInfo.getServerNumber();
    private static String licenseAddress = System.getProperty("server.tongweb.license.license-ips");
    private static String licensePath = System.getProperty("server.tongweb.license.path");
    private static LicenseRemoteConfig.Ssl ssl;

    public static void registerDynamicLoadingListener(DynamicLoadingListener handler) {
        LicenseProviderFacade.registerDynamicLoadingListener(handler);
    }

    public static void validateFromServer() {
        if (LicenseProviderFacade.isFirst(true)) {
            LicenseProviderFacade.config("remote", productVersion, null, licenseAddress, ssl);
            LicenseProviderFacade.validate();
            LicenseProviderFacade.startWorker();
        }
    }

    public static void validateFromLocal() {
        if (LicenseProviderFacade.isFirst(true)) {
            LicenseProviderFacade.config("file", productVersion, licensePath, null, ssl);
            LicenseProviderFacade.validate();
            LicenseProviderFacade.startWorker();
        }
    }

    public static void validateFromLocalOrServer() {
        if (LicenseProviderFacade.isFirst(true)) {
            LicenseProviderFacade.config(validType, productVersion, licensePath, licenseAddress, ssl);
            LicenseProviderFacade.validate();
            LicenseProviderFacade.startWorker();
        }
    }

    static {
        String sslenabled = System.getProperty("server.tongweb.license.ssl.enabled");
        String keyStore = System.getProperty("server.tongweb.license.ssl.keyStore");
        String keyStorePassword = System.getProperty("server.tongweb.license.ssl.keyStorePassword");
        String keyStoreType = System.getProperty("server.tongweb.license.ssl.keyStoreType");
        String trustStore = System.getProperty("server.tongweb.license.ssl.trustStore");
        String trustStorePassword = System.getProperty("server.tongweb.license.ssl.trustStorePassword");
        String trustStoreType = System.getProperty("server.tongweb.license.ssl.trustStoreType");
        if (StringUtils.isNotEmpty(sslenabled) && sslenabled.equals("true")) {
            ssl = new LicenseRemoteConfig.Ssl();
            ssl.setKeyStore(keyStore);
            ssl.setKeyStorePassword(keyStorePassword);
            ssl.setKeyStoreType(keyStoreType);
            ssl.setTrustStore(trustStore);
            ssl.setTrustStorePassword(trustStorePassword);
            ssl.setTrustStoreType(trustStoreType);
        }
    }
}

