/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.backend;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.ha.backend.HeartbeatListener;
import com.tongweb.container.ha.backend.Sender;
import com.tongweb.web.util.res.StringManager;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.charset.StandardCharsets;

public class MultiCastSender
implements Sender {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    private static final StringManager sm = StringManager.getManager(MultiCastSender.class);
    HeartbeatListener config = null;
    MulticastSocket s = null;
    InetAddress group = null;

    @Override
    public void init(HeartbeatListener config) throws Exception {
        this.config = config;
    }

    @Override
    public int send(String mess) throws Exception {
        if (this.s == null) {
            try {
                this.group = InetAddress.getByName(this.config.getGroup());
                if (this.config.getHost() != null) {
                    InetAddress addr = InetAddress.getByName(this.config.getHost());
                    InetSocketAddress addrs = new InetSocketAddress(addr, this.config.getMultiport());
                    this.s = new MulticastSocket(addrs);
                } else {
                    this.s = new MulticastSocket(this.config.getMultiport());
                }
                this.s.setTimeToLive(this.config.getTtl());
                this.s.joinGroup(this.group);
            }
            catch (Exception ex) {
                log.error(sm.getString("multiCastSender.multiCastFailed"), ex);
                this.s = null;
                return -1;
            }
        }
        byte[] buf = mess.getBytes(StandardCharsets.US_ASCII);
        DatagramPacket data = new DatagramPacket(buf, buf.length, this.group, this.config.getMultiport());
        try {
            this.s.send(data);
        }
        catch (Exception ex) {
            log.error(sm.getString("multiCastSender.sendFailed"), ex);
            this.s.close();
            this.s = null;
            return -1;
        }
        return 0;
    }
}

