/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.backend;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.ha.backend.HeartbeatListener;
import com.tongweb.container.ha.backend.Proxy;
import com.tongweb.container.ha.backend.Sender;
import com.tongweb.web.util.res.StringManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.StringTokenizer;

public class TcpSender
implements Sender {
    private static final Log log = LogFactory.getLog(HeartbeatListener.class);
    private static final StringManager sm = StringManager.getManager(TcpSender.class);
    HeartbeatListener config = null;
    protected Proxy[] proxies = null;
    protected Socket[] connections = null;
    protected BufferedReader[] connectionReaders = null;
    protected BufferedWriter[] connectionWriters = null;

    @Override
    public void init(HeartbeatListener config) throws Exception {
        this.config = config;
        StringTokenizer tok = new StringTokenizer(config.getProxyList(), ",");
        this.proxies = new Proxy[tok.countTokens()];
        int i2 = 0;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken().trim();
            int pos = token.indexOf(58);
            if (pos <= 0) {
                throw new Exception(sm.getString("tcpSender.invalidProxyList"));
            }
            this.proxies[i2] = new Proxy();
            this.proxies[i2].port = Integer.parseInt(token.substring(pos + 1));
            try {
                this.proxies[i2].address = InetAddress.getByName(token.substring(0, pos));
            }
            catch (Exception e2) {
                throw new Exception(sm.getString("tcpSender.invalidProxyList"));
            }
            ++i2;
        }
        this.connections = new Socket[this.proxies.length];
        this.connectionReaders = new BufferedReader[this.proxies.length];
        this.connectionWriters = new BufferedWriter[this.proxies.length];
    }

    @Override
    public int send(String mess) throws Exception {
        if (this.connections == null) {
            log.error(sm.getString("tcpSender.notInitialized"));
            return -1;
        }
        String requestLine = "POST " + this.config.getProxyURL() + " HTTP/1.0";
        block4: for (int i2 = 0; i2 < this.connections.length; ++i2) {
            if (this.connections[i2] == null) {
                try {
                    if (this.config.getHost() != null) {
                        this.connections[i2] = new Socket();
                        InetAddress addr = InetAddress.getByName(this.config.getHost());
                        InetSocketAddress addrs = new InetSocketAddress(addr, 0);
                        this.connections[i2].setReuseAddress(true);
                        this.connections[i2].bind(addrs);
                        addrs = new InetSocketAddress(this.proxies[i2].address, this.proxies[i2].port);
                        this.connections[i2].connect(addrs);
                    } else {
                        this.connections[i2] = new Socket(this.proxies[i2].address, this.proxies[i2].port);
                    }
                    this.connectionReaders[i2] = new BufferedReader(new InputStreamReader(this.connections[i2].getInputStream()));
                    this.connectionWriters[i2] = new BufferedWriter(new OutputStreamWriter(this.connections[i2].getOutputStream()));
                }
                catch (Exception ex) {
                    log.error(sm.getString("tcpSender.connectionFailed"), ex);
                    this.close(i2);
                }
            }
            if (this.connections[i2] == null) continue;
            BufferedWriter writer = this.connectionWriters[i2];
            try {
                writer.write(requestLine);
                writer.write("\r\n");
                writer.write("Content-Length: " + mess.length() + "\r\n");
                writer.write("User-Agent: HeartbeatListener/1.0\r\n");
                writer.write("Connection: Keep-Alive\r\n");
                writer.write("\r\n");
                writer.write(mess);
                writer.write("\r\n");
                writer.flush();
            }
            catch (Exception ex) {
                log.error(sm.getString("tcpSender.sendFailed"), ex);
                this.close(i2);
            }
            if (this.connections[i2] == null) continue;
            String responseStatus = this.connectionReaders[i2].readLine();
            if (responseStatus == null) {
                log.error(sm.getString("tcpSender.responseError"));
                this.close(i2);
                continue;
            }
            int status = Integer.parseInt(responseStatus = responseStatus.substring(responseStatus.indexOf(32) + 1, responseStatus.indexOf(32, responseStatus.indexOf(32) + 1)));
            if (status != 200) {
                log.error(sm.getString("tcpSender.responseErrorCode", status));
                this.close(i2);
                continue;
            }
            String header = this.connectionReaders[i2].readLine();
            int contentLength = 0;
            while (header != null && !header.isEmpty()) {
                int colon = header.indexOf(58);
                String headerName = header.substring(0, colon).trim();
                String headerValue = header.substring(colon + 1).trim();
                if ("content-length".equalsIgnoreCase(headerName)) {
                    contentLength = Integer.parseInt(headerValue);
                }
                header = this.connectionReaders[i2].readLine();
            }
            if (contentLength <= 0) continue;
            char[] buf = new char[512];
            while (contentLength > 0) {
                int thisTime = contentLength > buf.length ? buf.length : contentLength;
                int n = this.connectionReaders[i2].read(buf, 0, thisTime);
                if (n <= 0) {
                    log.error(sm.getString("tcpSender.readError"));
                    this.close(i2);
                    continue block4;
                }
                contentLength -= n;
            }
        }
        return 0;
    }

    protected void close(int i2) {
        try {
            if (this.connectionReaders[i2] != null) {
                this.connectionReaders[i2].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connectionReaders[i2] = null;
        try {
            if (this.connectionWriters[i2] != null) {
                this.connectionWriters[i2].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connectionWriters[i2] = null;
        try {
            if (this.connections[i2] != null) {
                this.connections[i2].close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connections[i2] = null;
    }
}

