/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.session;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.DistributedManager;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.Session;
import com.tongweb.container.ha.ClusterManager;
import com.tongweb.container.ha.ClusterMessage;
import com.tongweb.container.ha.session.ClusterManagerBase;
import com.tongweb.container.ha.session.DeltaSession;
import com.tongweb.container.tribes.Channel;
import com.tongweb.container.tribes.tipis.AbstractReplicatedMap;
import com.tongweb.container.tribes.tipis.LazyReplicatedMap;
import com.tongweb.web.util.res.StringManager;
import java.util.HashSet;
import java.util.Set;

public class BackupManager
extends ClusterManagerBase
implements AbstractReplicatedMap.MapOwner,
DistributedManager {
    private final Log log = LogFactory.getLog(BackupManager.class);
    protected static final StringManager sm = StringManager.getManager(BackupManager.class);
    protected static final long DEFAULT_REPL_TIMEOUT = 15000L;
    protected String name;
    private int mapSendOptions = 6;
    private long rpcTimeout = 15000L;
    private boolean terminateOnStartFailure = false;
    private long accessTimeout = 5000L;

    @Override
    public void messageDataReceived(ClusterMessage msg) {
    }

    @Override
    public ClusterMessage requestCompleted(String sessionId) {
        if (!this.getState().isAvailable()) {
            return null;
        }
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        map.replicate(sessionId, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectMadePrimary(Object key, Object value) {
        if (value instanceof DeltaSession) {
            DeltaSession session;
            DeltaSession deltaSession = session = (DeltaSession)value;
            synchronized (deltaSession) {
                session.access();
                session.setPrimarySession(true);
                session.endAccess();
            }
        }
    }

    @Override
    public Session createEmptySession() {
        return new DeltaSession(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        super.startInternal();
        try {
            if (this.cluster == null) {
                throw new LifecycleException(sm.getString("backupManager.noCluster", this.getName()));
            }
            LazyReplicatedMap map = new LazyReplicatedMap((AbstractReplicatedMap.MapOwner)this, this.cluster.getChannel(), this.rpcTimeout, this.getMapName(), this.getClassLoaders(), this.terminateOnStartFailure);
            map.setChannelSendOptions(this.mapSendOptions);
            map.setAccessTimeout(this.accessTimeout);
            this.sessions = map;
        }
        catch (Exception x) {
            this.log.error(sm.getString("backupManager.startUnable", this.getName()), x);
            throw new LifecycleException(sm.getString("backupManager.startFailed", this.getName()), x);
        }
        this.setState(LifecycleState.STARTING);
    }

    public String getMapName() {
        String name = this.cluster.getManagerName(this.getName(), this) + "-map";
        if (this.log.isDebugEnabled()) {
            this.log.debug("Backup manager, Setting map name to:" + name);
        }
        return name;
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug(sm.getString("backupManager.stopped", this.getName()));
        }
        this.setState(LifecycleState.STOPPING);
        if (this.sessions instanceof LazyReplicatedMap) {
            LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
            map.breakdown();
        }
        super.stopInternal();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setMapSendOptions(int mapSendOptions) {
        this.mapSendOptions = mapSendOptions;
    }

    public void setMapSendOptions(String mapSendOptions) {
        int value = Channel.parseSendOptions(mapSendOptions);
        if (value > 0) {
            this.setMapSendOptions(value);
        }
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public String getMapSendOptionsName() {
        return Channel.getSendOptionsAsString(this.mapSendOptions);
    }

    public void setRpcTimeout(long rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }

    public void setTerminateOnStartFailure(boolean terminateOnStartFailure) {
        this.terminateOnStartFailure = terminateOnStartFailure;
    }

    public boolean isTerminateOnStartFailure() {
        return this.terminateOnStartFailure;
    }

    public long getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setAccessTimeout(long accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    @Override
    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    @Override
    public ClusterManager cloneFromTemplate() {
        BackupManager result = new BackupManager();
        this.clone(result);
        result.mapSendOptions = this.mapSendOptions;
        result.rpcTimeout = this.rpcTimeout;
        result.terminateOnStartFailure = this.terminateOnStartFailure;
        result.accessTimeout = this.accessTimeout;
        return result;
    }

    @Override
    public int getActiveSessionsFull() {
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        return map.sizeFull();
    }

    @Override
    public Set<String> getSessionIdsFull() {
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        HashSet<String> sessionIds = new HashSet<String>(map.keySetFull());
        return sessionIds;
    }
}

