/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.session;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.ha.ClusterListener;
import com.tongweb.container.ha.ClusterManager;
import com.tongweb.container.ha.ClusterMessage;
import com.tongweb.container.ha.session.SessionMessage;
import com.tongweb.container.ha.session.SessionMessageImpl;
import com.tongweb.web.util.res.StringManager;
import java.util.Map;

public class ClusterSessionListener
extends ClusterListener {
    private static final Log log = LogFactory.getLog(ClusterSessionListener.class);
    private static final StringManager sm = StringManager.getManager(ClusterSessionListener.class);

    @Override
    public void messageReceived(ClusterMessage myobj) {
        if (myobj instanceof SessionMessage) {
            SessionMessage msg = (SessionMessage)myobj;
            String ctxname = msg.getContextName();
            Map<String, ClusterManager> managers = this.cluster.getManagers();
            if (ctxname == null) {
                for (Map.Entry<String, ClusterManager> entry : managers.entrySet()) {
                    if (entry.getValue() != null) {
                        entry.getValue().messageDataReceived(msg);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug(sm.getString("clusterSessionListener.noManager", entry.getKey()));
                }
            } else {
                ClusterManager mgr = managers.get(ctxname);
                if (mgr != null) {
                    mgr.messageDataReceived(msg);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn(sm.getString("clusterSessionListener.noManager", ctxname));
                    }
                    if (msg.getEventType() == 4) {
                        SessionMessageImpl replymsg = new SessionMessageImpl(ctxname, 16, null, "NO-CONTEXT-MANAGER", "NO-CONTEXT-MANAGER-" + ctxname);
                        this.cluster.send(replymsg, msg.getAddress());
                    }
                }
            }
        }
    }

    @Override
    public boolean accept(ClusterMessage msg) {
        return msg instanceof SessionMessage;
    }
}

