/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.session;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Cluster;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.Manager;
import com.tongweb.container.Session;
import com.tongweb.container.connector.Request;
import com.tongweb.container.connector.Response;
import com.tongweb.container.ha.CatalinaCluster;
import com.tongweb.container.ha.ClusterManager;
import com.tongweb.container.ha.ClusterValve;
import com.tongweb.container.session.ManagerBase;
import com.tongweb.container.session.PersistentManager;
import com.tongweb.container.valves.ValveBase;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import javax.servlet.ServletException;

public class JvmRouteBinderValve
extends ValveBase
implements ClusterValve {
    public static final Log log = LogFactory.getLog(JvmRouteBinderValve.class);
    protected CatalinaCluster cluster;
    protected static final StringManager sm = StringManager.getManager(JvmRouteBinderValve.class);
    protected boolean enabled = true;
    protected long numberOfSessions = 0L;
    protected String sessionIdAttribute = "com.tongweb.container.ha.session.JvmRouteOriginalSessionID";

    public JvmRouteBinderValve() {
        super(true);
    }

    public String getSessionIdAttribute() {
        return this.sessionIdAttribute;
    }

    public void setSessionIdAttribute(String sessionIdAttribute) {
        this.sessionIdAttribute = sessionIdAttribute;
    }

    public long getNumberOfSessions() {
        return this.numberOfSessions;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Manager manager;
        if (this.getEnabled() && request.getContext() != null && request.getContext().getDistributable() && !request.isAsyncDispatching() && (manager = request.getContext().getManager()) != null && (manager instanceof ClusterManager && this.getCluster() != null && this.getCluster().getManager(((ClusterManager)manager).getName()) != null || manager instanceof PersistentManager)) {
            this.handlePossibleTurnover(request);
        }
        this.getNext().invoke(request, response);
    }

    protected void handlePossibleTurnover(Request request) {
        String sessionID = request.getRequestedSessionId();
        if (sessionID != null) {
            long t1 = System.currentTimeMillis();
            String jvmRoute = this.getLocalJvmRoute(request);
            if (jvmRoute == null) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("jvmRoute.missingJvmRouteAttribute"));
                }
                return;
            }
            this.handleJvmRoute(request, sessionID, jvmRoute);
            if (log.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                long time = t2 - t1;
                log.debug(sm.getString("jvmRoute.turnoverInfo", time));
            }
        }
    }

    protected String getLocalJvmRoute(Request request) {
        Manager manager = this.getManager(request);
        if (manager instanceof ManagerBase) {
            return ((ManagerBase)manager).getJvmRoute();
        }
        return null;
    }

    protected Manager getManager(Request request) {
        Manager manager = request.getContext().getManager();
        if (log.isDebugEnabled()) {
            if (manager != null) {
                log.debug(sm.getString("jvmRoute.foundManager", manager, request.getContext().getName()));
            } else {
                log.debug(sm.getString("jvmRoute.notFoundManager", request.getContext().getName()));
            }
        }
        return manager;
    }

    @Override
    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setCluster(CatalinaCluster cluster) {
        this.cluster = cluster;
    }

    protected void handleJvmRoute(Request request, String sessionId, String localJvmRoute) {
        String requestJvmRoute = null;
        int index = sessionId.indexOf(46);
        if (index > 0) {
            requestJvmRoute = sessionId.substring(index + 1);
        }
        if (requestJvmRoute != null && !requestJvmRoute.equals(localJvmRoute)) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jvmRoute.failover", requestJvmRoute, localJvmRoute, sessionId));
            }
            Session catalinaSession = null;
            try {
                catalinaSession = this.getManager(request).findSession(sessionId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String id = sessionId.substring(0, index);
            String newSessionID = id + "." + localJvmRoute;
            if (catalinaSession != null) {
                this.changeSessionID(request, sessionId, newSessionID, catalinaSession);
                ++this.numberOfSessions;
            } else {
                try {
                    catalinaSession = this.getManager(request).findSession(newSessionID);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (catalinaSession != null) {
                    this.changeRequestSessionID(request, sessionId, newSessionID);
                } else if (log.isDebugEnabled()) {
                    log.debug(sm.getString("jvmRoute.cannotFindSession", sessionId));
                }
            }
        }
    }

    protected void changeSessionID(Request request, String sessionId, String newSessionID, Session catalinaSession) {
        this.fireLifecycleEvent("Before session migration", catalinaSession);
        catalinaSession.getManager().changeSessionId(catalinaSession, newSessionID);
        this.changeRequestSessionID(request, sessionId, newSessionID);
        this.fireLifecycleEvent("After session migration", catalinaSession);
        if (log.isDebugEnabled()) {
            log.debug(sm.getString("jvmRoute.changeSession", sessionId, newSessionID));
        }
    }

    protected void changeRequestSessionID(Request request, String sessionId, String newSessionID) {
        request.changeSessionId(newSessionID);
        if (this.sessionIdAttribute != null && !this.sessionIdAttribute.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("jvmRoute.set.originalsessionid", this.sessionIdAttribute, sessionId));
            }
            request.setAttribute(this.sessionIdAttribute, sessionId);
        }
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        Cluster containerCluster;
        if (this.cluster == null && (containerCluster = this.getContainer().getCluster()) instanceof CatalinaCluster) {
            this.setCluster((CatalinaCluster)containerCluster);
        }
        if (log.isInfoEnabled()) {
            log.info(sm.getString("jvmRoute.valve.started"));
            if (this.cluster == null) {
                log.info(sm.getString("jvmRoute.noCluster"));
            }
        }
        super.startInternal();
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        super.stopInternal();
        this.cluster = null;
        this.numberOfSessions = 0L;
        if (log.isInfoEnabled()) {
            log.info(sm.getString("jvmRoute.valve.stopped"));
        }
    }
}

