/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ha.tcp;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Container;
import com.tongweb.container.Context;
import com.tongweb.container.Engine;
import com.tongweb.container.Host;
import com.tongweb.container.LifecycleException;
import com.tongweb.container.LifecycleState;
import com.tongweb.container.Manager;
import com.tongweb.container.Valve;
import com.tongweb.container.ha.CatalinaCluster;
import com.tongweb.container.ha.ClusterDeployer;
import com.tongweb.container.ha.ClusterListener;
import com.tongweb.container.ha.ClusterManager;
import com.tongweb.container.ha.ClusterMessage;
import com.tongweb.container.ha.ClusterValve;
import com.tongweb.container.ha.session.ClusterSessionListener;
import com.tongweb.container.ha.session.DeltaManager;
import com.tongweb.container.ha.session.JvmRouteBinderValve;
import com.tongweb.container.ha.tcp.ReplicationValve;
import com.tongweb.container.ha.tcp.SendMessageData;
import com.tongweb.container.tribes.Channel;
import com.tongweb.container.tribes.ChannelListener;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.MembershipListener;
import com.tongweb.container.tribes.group.GroupChannel;
import com.tongweb.container.tribes.group.interceptors.MessageDispatchInterceptor;
import com.tongweb.container.tribes.group.interceptors.TcpFailureDetector;
import com.tongweb.container.util.LifecycleMBeanBase;
import com.tongweb.container.util.ToStringUtil;
import com.tongweb.web.util.res.StringManager;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.ObjectName;

public class SimpleTcpCluster
extends LifecycleMBeanBase
implements CatalinaCluster,
MembershipListener,
ChannelListener {
    public static final Log log = LogFactory.getLog(SimpleTcpCluster.class);
    public static final String BEFORE_MEMBERREGISTER_EVENT = "before_member_register";
    public static final String AFTER_MEMBERREGISTER_EVENT = "after_member_register";
    public static final String BEFORE_MANAGERREGISTER_EVENT = "before_manager_register";
    public static final String AFTER_MANAGERREGISTER_EVENT = "after_manager_register";
    public static final String BEFORE_MANAGERUNREGISTER_EVENT = "before_manager_unregister";
    public static final String AFTER_MANAGERUNREGISTER_EVENT = "after_manager_unregister";
    public static final String BEFORE_MEMBERUNREGISTER_EVENT = "before_member_unregister";
    public static final String AFTER_MEMBERUNREGISTER_EVENT = "after_member_unregister";
    public static final String SEND_MESSAGE_FAILURE_EVENT = "send_message_failure";
    public static final String RECEIVE_MESSAGE_FAILURE_EVENT = "receive_message_failure";
    protected Channel channel = new GroupChannel();
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.ha.tcp");
    protected String clusterName;
    protected boolean heartbeatBackgroundEnabled = false;
    protected Container container = null;
    protected final PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected final Map<String, ClusterManager> managers = new HashMap<String, ClusterManager>();
    protected ClusterManager managerTemplate = new DeltaManager();
    private final List<Valve> valves = new ArrayList<Valve>();
    private ClusterDeployer clusterDeployer;
    private ObjectName onameClusterDeployer;
    protected final List<ClusterListener> clusterListeners = new ArrayList<ClusterListener>();
    private boolean notifyLifecycleListenerOnFailure = false;
    private int channelSendOptions = 8;
    private int channelStartOptions = 15;
    private final Map<Member, ObjectName> memberOnameMap = new ConcurrentHashMap<Member, ObjectName>();
    protected boolean hasMembers = false;

    public boolean isHeartbeatBackgroundEnabled() {
        return this.heartbeatBackgroundEnabled;
    }

    public void setHeartbeatBackgroundEnabled(boolean heartbeatBackgroundEnabled) {
        this.heartbeatBackgroundEnabled = heartbeatBackgroundEnabled;
    }

    @Override
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public String getClusterName() {
        if (this.clusterName == null && this.container != null) {
            return this.container.getName();
        }
        return this.clusterName;
    }

    @Override
    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    public boolean isNotifyLifecycleListenerOnFailure() {
        return this.notifyLifecycleListenerOnFailure;
    }

    public void setNotifyLifecycleListenerOnFailure(boolean notifyListenerOnFailure) {
        boolean oldNotifyListenerOnFailure = this.notifyLifecycleListenerOnFailure;
        this.notifyLifecycleListenerOnFailure = notifyListenerOnFailure;
        this.support.firePropertyChange("notifyLifecycleListenerOnFailure", oldNotifyListenerOnFailure, this.notifyLifecycleListenerOnFailure);
    }

    @Override
    public void addValve(Valve valve) {
        if (valve instanceof ClusterValve && !this.valves.contains(valve)) {
            this.valves.add(valve);
        }
    }

    @Override
    public Valve[] getValves() {
        return this.valves.toArray(new Valve[0]);
    }

    public ClusterListener[] findClusterListeners() {
        if (this.clusterListeners.size() > 0) {
            ClusterListener[] listener = new ClusterListener[this.clusterListeners.size()];
            this.clusterListeners.toArray(listener);
            return listener;
        }
        return new ClusterListener[0];
    }

    @Override
    public void addClusterListener(ClusterListener listener) {
        if (listener != null && !this.clusterListeners.contains(listener)) {
            this.clusterListeners.add(listener);
            listener.setCluster(this);
        }
    }

    @Override
    public void removeClusterListener(ClusterListener listener) {
        if (listener != null) {
            this.clusterListeners.remove(listener);
            listener.setCluster(null);
        }
    }

    @Override
    public ClusterDeployer getClusterDeployer() {
        return this.clusterDeployer;
    }

    @Override
    public void setClusterDeployer(ClusterDeployer clusterDeployer) {
        this.clusterDeployer = clusterDeployer;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setManagerTemplate(ClusterManager managerTemplate) {
        this.managerTemplate = managerTemplate;
    }

    public void setChannelSendOptions(int channelSendOptions) {
        this.channelSendOptions = channelSendOptions;
    }

    public void setChannelSendOptions(String channelSendOptions) {
        int value = Channel.parseSendOptions(channelSendOptions);
        if (value > 0) {
            this.setChannelSendOptions(value);
        }
    }

    @Override
    public boolean hasMembers() {
        return this.hasMembers;
    }

    @Override
    public Member[] getMembers() {
        return this.channel.getMembers();
    }

    @Override
    public Member getLocalMember() {
        return this.channel.getLocalMember(true);
    }

    @Override
    public Map<String, ClusterManager> getManagers() {
        return this.managers;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    public ClusterManager getManagerTemplate() {
        return this.managerTemplate;
    }

    public int getChannelSendOptions() {
        return this.channelSendOptions;
    }

    public String getChannelSendOptionsName() {
        return Channel.getSendOptionsAsString(this.channelSendOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Manager createManager(String name) {
        if (log.isDebugEnabled()) {
            log.debug("Creating ClusterManager for context " + name + " using class " + this.getManagerTemplate().getClass().getName());
        }
        ClusterManager manager = null;
        try {
            manager = this.managerTemplate.cloneFromTemplate();
            manager.setName(name);
        }
        catch (Exception x) {
            log.error(sm.getString("simpleTcpCluster.clustermanager.cloneFailed"), x);
            manager = new DeltaManager();
        }
        finally {
            if (manager != null) {
                manager.setCluster(this);
            }
        }
        return manager;
    }

    @Override
    public void registerManager(Manager manager) {
        if (!(manager instanceof ClusterManager)) {
            log.warn(sm.getString("simpleTcpCluster.clustermanager.notImplement", manager));
            return;
        }
        ClusterManager cmanager = (ClusterManager)manager;
        this.fireLifecycleEvent(BEFORE_MANAGERREGISTER_EVENT, manager);
        String clusterName = this.getManagerName(cmanager.getName(), manager);
        cmanager.setName(clusterName);
        cmanager.setCluster(this);
        this.managers.put(clusterName, cmanager);
        this.fireLifecycleEvent(AFTER_MANAGERREGISTER_EVENT, manager);
    }

    @Override
    public void removeManager(Manager manager) {
        if (manager instanceof ClusterManager) {
            ClusterManager cmgr = (ClusterManager)manager;
            this.fireLifecycleEvent(BEFORE_MANAGERUNREGISTER_EVENT, manager);
            this.managers.remove(this.getManagerName(cmgr.getName(), manager));
            cmgr.setCluster(null);
            this.fireLifecycleEvent(AFTER_MANAGERUNREGISTER_EVENT, manager);
        }
    }

    @Override
    public String getManagerName(String name, Manager manager) {
        Context context;
        Container host;
        String clusterName = name;
        if (clusterName == null) {
            clusterName = manager.getContext().getName();
        }
        if (this.getContainer() instanceof Engine && (host = (context = manager.getContext()).getParent()) instanceof Host && clusterName != null && !clusterName.startsWith(host.getName() + "#")) {
            clusterName = host.getName() + "#" + clusterName;
        }
        return clusterName;
    }

    @Override
    public Manager getManager(String name) {
        return this.managers.get(name);
    }

    @Override
    public void backgroundProcess() {
        if (this.clusterDeployer != null) {
            this.clusterDeployer.backgroundProcess();
        }
        if (this.isHeartbeatBackgroundEnabled() && this.channel != null) {
            this.channel.heartbeat();
        }
        this.fireLifecycleEvent("periodic", null);
    }

    @Override
    protected void initInternal() throws LifecycleException {
        super.initInternal();
        if (this.clusterDeployer != null) {
            StringBuilder name = new StringBuilder("type=Cluster");
            Container container = this.getContainer();
            if (container != null) {
                name.append(container.getMBeanKeyProperties());
            }
            name.append(",component=Deployer");
            this.onameClusterDeployer = this.register(this.clusterDeployer, name.toString());
        }
        this.channel.setUtilityExecutor(Container.getService(this.getContainer()).getServer().getUtilityExecutor());
    }

    @Override
    protected void startInternal() throws LifecycleException {
        if (log.isInfoEnabled()) {
            log.info(sm.getString("simpleTcpCluster.start"));
        }
        try {
            this.checkDefaults();
            this.registerClusterValve();
            this.channel.addMembershipListener(this);
            this.channel.addChannelListener(this);
            this.channel.setName(this.getClusterName() + "-Channel");
            this.channel.start(this.channelStartOptions);
            if (this.clusterDeployer != null) {
                this.clusterDeployer.start();
            }
            this.registerMember(this.channel.getLocalMember(false));
        }
        catch (Exception x) {
            log.error(sm.getString("simpleTcpCluster.startUnable"), x);
            throw new LifecycleException(x);
        }
        this.setState(LifecycleState.STARTING);
    }

    protected void checkDefaults() {
        if (this.clusterListeners.size() == 0 && this.managerTemplate instanceof DeltaManager) {
            this.addClusterListener(new ClusterSessionListener());
        }
        if (this.valves.size() == 0) {
            this.addValve(new JvmRouteBinderValve());
            this.addValve(new ReplicationValve());
        }
        if (this.clusterDeployer != null) {
            this.clusterDeployer.setCluster(this);
        }
        if (this.channel == null) {
            this.channel = new GroupChannel();
        }
        if (this.channel instanceof GroupChannel && !((GroupChannel)this.channel).getInterceptors().hasNext()) {
            this.channel.addInterceptor(new MessageDispatchInterceptor());
            this.channel.addInterceptor(new TcpFailureDetector());
        }
        if (this.heartbeatBackgroundEnabled) {
            this.channel.setHeartbeat(false);
        }
    }

    protected void registerClusterValve() {
        if (this.container != null) {
            for (Valve v : this.valves) {
                ClusterValve valve = (ClusterValve)v;
                if (log.isDebugEnabled()) {
                    log.debug("Invoking addValve on " + this.getContainer() + " with class=" + valve.getClass().getName());
                }
                if (valve == null) continue;
                this.container.getPipeline().addValve(valve);
                valve.setCluster(this);
            }
        }
    }

    protected void unregisterClusterValve() {
        for (Valve v : this.valves) {
            ClusterValve valve = (ClusterValve)v;
            if (log.isDebugEnabled()) {
                log.debug("Invoking removeValve on " + this.getContainer() + " with class=" + valve.getClass().getName());
            }
            if (valve == null) continue;
            this.container.getPipeline().removeValve(valve);
            valve.setCluster(null);
        }
    }

    @Override
    protected void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        this.unregisterMember(this.channel.getLocalMember(false));
        if (this.clusterDeployer != null) {
            this.clusterDeployer.stop();
        }
        this.managers.clear();
        try {
            if (this.clusterDeployer != null) {
                this.clusterDeployer.setCluster(null);
            }
            this.channel.stop(this.channelStartOptions);
            this.channel.removeChannelListener(this);
            this.channel.removeMembershipListener(this);
            this.unregisterClusterValve();
        }
        catch (Exception x) {
            log.error(sm.getString("simpleTcpCluster.stopUnable"), x);
        }
    }

    @Override
    protected void destroyInternal() throws LifecycleException {
        if (this.onameClusterDeployer != null) {
            this.unregister(this.onameClusterDeployer);
            this.onameClusterDeployer = null;
        }
        super.destroyInternal();
    }

    public String toString() {
        return ToStringUtil.toString(this);
    }

    @Override
    public void send(ClusterMessage msg) {
        this.send(msg, null);
    }

    @Override
    public void send(ClusterMessage msg, Member dest) {
        this.send(msg, dest, this.channelSendOptions);
    }

    @Override
    public void send(ClusterMessage msg, Member dest, int sendOptions) {
        try {
            msg.setAddress(this.getLocalMember());
            if (dest != null) {
                if (!this.getLocalMember().equals(dest)) {
                    this.channel.send(new Member[]{dest}, msg, sendOptions);
                } else {
                    log.error(sm.getString("simpleTcpCluster.unableSend.localMember", msg));
                }
            } else {
                Member[] destmembers = this.channel.getMembers();
                if (destmembers.length > 0) {
                    this.channel.send(destmembers, msg, sendOptions);
                } else if (log.isDebugEnabled()) {
                    log.debug("No members in cluster, ignoring message:" + msg);
                }
            }
        }
        catch (Exception x) {
            log.error(sm.getString("simpleTcpCluster.sendFailed"), x);
        }
    }

    @Override
    public void memberAdded(Member member) {
        try {
            this.hasMembers = this.channel.hasMembers();
            if (log.isInfoEnabled()) {
                log.info(sm.getString("simpleTcpCluster.member.added", member));
            }
            this.fireLifecycleEvent(BEFORE_MEMBERREGISTER_EVENT, member);
            this.registerMember(member);
            this.fireLifecycleEvent(AFTER_MEMBERREGISTER_EVENT, member);
        }
        catch (Exception x) {
            log.error(sm.getString("simpleTcpCluster.member.addFailed"), x);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        try {
            this.hasMembers = this.channel.hasMembers();
            if (log.isInfoEnabled()) {
                log.info(sm.getString("simpleTcpCluster.member.disappeared", member));
            }
            this.fireLifecycleEvent(BEFORE_MEMBERUNREGISTER_EVENT, member);
            this.unregisterMember(member);
            this.fireLifecycleEvent(AFTER_MEMBERUNREGISTER_EVENT, member);
        }
        catch (Exception x) {
            log.error(sm.getString("simpleTcpCluster.member.removeFailed"), x);
        }
    }

    @Override
    public boolean accept(Serializable msg, Member sender) {
        return msg instanceof ClusterMessage;
    }

    @Override
    public void messageReceived(Serializable message, Member sender) {
        ClusterMessage fwd = (ClusterMessage)message;
        fwd.setAddress(sender);
        this.messageReceived(fwd);
    }

    public void messageReceived(ClusterMessage message) {
        if (log.isDebugEnabled() && message != null) {
            log.debug("Assuming clocks are synched: Replication for " + message.getUniqueId() + " took=" + (System.currentTimeMillis() - message.getTimestamp()) + " ms.");
        }
        boolean accepted = false;
        if (message != null) {
            for (ClusterListener listener : this.clusterListeners) {
                if (!listener.accept(message)) continue;
                accepted = true;
                listener.messageReceived(message);
            }
            if (!accepted && this.notifyLifecycleListenerOnFailure) {
                Member dest = message.getAddress();
                this.fireLifecycleEvent(RECEIVE_MESSAGE_FAILURE_EVENT, new SendMessageData(message, dest, null));
                if (log.isDebugEnabled()) {
                    log.debug("Message " + message.toString() + " from type " + message.getClass().getName() + " transferred but no listener registered");
                }
            }
        }
    }

    public int getChannelStartOptions() {
        return this.channelStartOptions;
    }

    public void setChannelStartOptions(int channelStartOptions) {
        this.channelStartOptions = channelStartOptions;
    }

    @Override
    protected String getDomainInternal() {
        Container container = this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getDomain();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        StringBuilder name = new StringBuilder("type=Cluster");
        Container container = this.getContainer();
        if (container != null) {
            name.append(container.getMBeanKeyProperties());
        }
        return name.toString();
    }

    private void registerMember(Member member) {
        StringBuilder name = new StringBuilder("type=Cluster");
        Container container = this.getContainer();
        if (container != null) {
            name.append(container.getMBeanKeyProperties());
        }
        name.append(",component=Member,name=");
        name.append(ObjectName.quote(member.getName()));
        ObjectName oname = this.register(member, name.toString());
        this.memberOnameMap.put(member, oname);
    }

    private void unregisterMember(Member member) {
        if (member == null) {
            return;
        }
        ObjectName oname = this.memberOnameMap.remove(member);
        if (oname != null) {
            this.unregister(oname);
        }
    }
}

