/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.mbeans;

import com.tongweb.container.Group;
import com.tongweb.container.Role;
import com.tongweb.container.User;
import com.tongweb.container.mbeans.MBeanUtils;
import com.tongweb.web.util.modeler.BaseModelMBean;
import com.tongweb.web.util.modeler.ManagedBean;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.res.StringManager;
import java.util.ArrayList;
import java.util.Iterator;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class UserMBean
extends BaseModelMBean {
    private static final StringManager sm = StringManager.getManager(UserMBean.class);
    protected final Registry registry = MBeanUtils.createRegistry();
    protected final ManagedBean managed = this.registry.findManagedBean("User");

    public String[] getGroups() {
        User user = (User)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<Group> groups = user.getGroups();
        while (groups.hasNext()) {
            Group group = null;
            try {
                group = groups.next();
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), group);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e2) {
                throw new IllegalArgumentException(sm.getString("userMBean.createError.group", group), e2);
            }
        }
        return results.toArray(new String[0]);
    }

    public String[] getRoles() {
        User user = (User)this.resource;
        ArrayList<String> results = new ArrayList<String>();
        Iterator<Role> roles = user.getRoles();
        while (roles.hasNext()) {
            Role role = null;
            try {
                role = roles.next();
                ObjectName oname = MBeanUtils.createObjectName(this.managed.getDomain(), role);
                results.add(oname.toString());
            }
            catch (MalformedObjectNameException e2) {
                throw new IllegalArgumentException(sm.getString("userMBean.createError.role", role), e2);
            }
        }
        return results.toArray(new String[0]);
    }

    public void addGroup(String groupname) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Group group = user.getUserDatabase().findGroup(groupname);
        if (group == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidGroup", groupname));
        }
        user.addGroup(group);
    }

    public void addRole(String rolename) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Role role = user.getUserDatabase().findRole(rolename);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", rolename));
        }
        user.addRole(role);
    }

    public void removeGroup(String groupname) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Group group = user.getUserDatabase().findGroup(groupname);
        if (group == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidGroup", groupname));
        }
        user.removeGroup(group);
    }

    public void removeRole(String rolename) {
        User user = (User)this.resource;
        if (user == null) {
            return;
        }
        Role role = user.getUserDatabase().findRole(rolename);
        if (role == null) {
            throw new IllegalArgumentException(sm.getString("userMBean.invalidRole", rolename));
        }
        user.removeRole(role);
    }
}

