/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.security;

public final class SecurityClassLoad {
    public static void securityClassLoad(ClassLoader loader) throws Exception {
        SecurityClassLoad.securityClassLoad(loader, true);
    }

    static void securityClassLoad(ClassLoader loader, boolean requireSecurityManager) throws Exception {
        if (requireSecurityManager && System.getSecurityManager() == null) {
            return;
        }
        SecurityClassLoad.loadCorePackage(loader);
        SecurityClassLoad.loadCoyotePackage(loader);
        SecurityClassLoad.loadLoaderPackage(loader);
        SecurityClassLoad.loadRealmPackage(loader);
        SecurityClassLoad.loadServletsPackage(loader);
        SecurityClassLoad.loadSessionPackage(loader);
        SecurityClassLoad.loadUtilPackage(loader);
        SecurityClassLoad.loadJavaxPackage(loader);
        SecurityClassLoad.loadConnectorPackage(loader);
        SecurityClassLoad.loadTomcatPackage(loader);
    }

    private static final void loadCorePackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.core.";
        loader.loadClass("com.tongweb.container.core.AccessLogAdapter");
        loader.loadClass("com.tongweb.container.core.ApplicationContextFacade$PrivilegedExecuteMethod");
        loader.loadClass("com.tongweb.container.core.ApplicationDispatcher$PrivilegedForward");
        loader.loadClass("com.tongweb.container.core.ApplicationDispatcher$PrivilegedInclude");
        loader.loadClass("com.tongweb.container.core.ApplicationPushBuilder");
        loader.loadClass("com.tongweb.container.core.AsyncContextImpl");
        loader.loadClass("com.tongweb.container.core.AsyncContextImpl$AsyncRunnable");
        loader.loadClass("com.tongweb.container.core.AsyncContextImpl$DebugException");
        loader.loadClass("com.tongweb.container.core.AsyncListenerWrapper");
        loader.loadClass("com.tongweb.container.core.ContainerBase$PrivilegedAddChild");
        loader.loadClass("com.tongweb.container.core.DefaultInstanceManager$AnnotationCacheEntry");
        loader.loadClass("com.tongweb.container.core.DefaultInstanceManager$AnnotationCacheEntryType");
        loader.loadClass("com.tongweb.container.core.DefaultInstanceManager$PrivilegedGetField");
        loader.loadClass("com.tongweb.container.core.DefaultInstanceManager$PrivilegedGetMethod");
        loader.loadClass("com.tongweb.container.core.DefaultInstanceManager$PrivilegedLoadClass");
        loader.loadClass("com.tongweb.container.core.ApplicationHttpRequest$AttributeNamesEnumerator");
    }

    private static final void loadLoaderPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.loader.";
        loader.loadClass("com.tongweb.container.loader.WebappClassLoaderBase$PrivilegedFindClassByName");
        loader.loadClass("com.tongweb.container.loader.WebappClassLoaderBase$PrivilegedHasLoggingConfig");
    }

    private static final void loadRealmPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.realm.";
        loader.loadClass("com.tongweb.container.realm.LockOutRealm$LockRecord");
    }

    private static final void loadServletsPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.servlets.";
        loader.loadClass("com.tongweb.container.servlets.DefaultServlet");
    }

    private static final void loadSessionPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.session.";
        loader.loadClass("com.tongweb.container.session.StandardSession");
        loader.loadClass("com.tongweb.container.session.StandardSession$PrivilegedNewSessionFacade");
        loader.loadClass("com.tongweb.container.session.StandardManager$PrivilegedDoUnload");
    }

    private static final void loadUtilPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.util.";
        loader.loadClass("com.tongweb.container.util.ParameterMap");
        loader.loadClass("com.tongweb.container.util.RequestUtil");
        loader.loadClass("com.tongweb.container.util.TLSUtil");
    }

    private static final void loadCoyotePackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.connector.";
        loader.loadClass("com.tongweb.connector.http11.Constants");
        Class<?> clazz = loader.loadClass("com.tongweb.connector.Constants");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        loader.loadClass("com.tongweb.connector.http2.Stream$PrivilegedPush");
    }

    private static final void loadJavaxPackage(ClassLoader loader) throws Exception {
        loader.loadClass("javax.servlet.http.Cookie");
    }

    private static final void loadConnectorPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.container.connector.";
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetAttributePrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetParameterMapPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetRequestDispatcherPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetParameterPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetParameterNamesPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetParameterValuePrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetCharacterEncodingPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetHeadersPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetHeaderNamesPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetCookiesPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetLocalePrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetLocalesPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.ResponseFacade$SetContentTypePrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.ResponseFacade$DateHeaderPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.RequestFacade$GetSessionPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.ResponseFacade$FlushBufferPrivilegedAction");
        loader.loadClass("com.tongweb.container.connector.OutputBuffer$PrivilegedCreateConverter");
        loader.loadClass("com.tongweb.container.connector.CoyoteInputStream$PrivilegedAvailable");
        loader.loadClass("com.tongweb.container.connector.CoyoteInputStream$PrivilegedClose");
        loader.loadClass("com.tongweb.container.connector.CoyoteInputStream$PrivilegedRead");
        loader.loadClass("com.tongweb.container.connector.CoyoteInputStream$PrivilegedReadArray");
        loader.loadClass("com.tongweb.container.connector.CoyoteInputStream$PrivilegedReadBuffer");
        loader.loadClass("com.tongweb.container.connector.CoyoteOutputStream");
        loader.loadClass("com.tongweb.container.connector.InputBuffer$PrivilegedCreateConverter");
        loader.loadClass("com.tongweb.container.connector.Response$PrivilegedDoIsEncodable");
        loader.loadClass("com.tongweb.container.connector.Response$PrivilegedGenerateCookieString");
        loader.loadClass("com.tongweb.container.connector.Response$PrivilegedEncodeUrl");
    }

    private static final void loadTomcatPackage(ClassLoader loader) throws Exception {
        String basePackage = "com.tongweb.web.";
        loader.loadClass("com.tongweb.web.util.buf.B2CConverter");
        loader.loadClass("com.tongweb.web.util.buf.ByteBufferUtils");
        loader.loadClass("com.tongweb.web.util.buf.C2BConverter");
        loader.loadClass("com.tongweb.web.util.buf.HexUtils");
        loader.loadClass("com.tongweb.web.util.buf.StringCache");
        loader.loadClass("com.tongweb.web.util.buf.StringCache$ByteEntry");
        loader.loadClass("com.tongweb.web.util.buf.StringCache$CharEntry");
        loader.loadClass("com.tongweb.web.util.buf.UriUtil");
        loader.loadClass("com.tongweb.web.util.collections.CaseInsensitiveKeyMap");
        loader.loadClass("com.tongweb.web.util.collections.CaseInsensitiveKeyMap$EntryImpl");
        loader.loadClass("com.tongweb.web.util.collections.CaseInsensitiveKeyMap$EntryIterator");
        loader.loadClass("com.tongweb.web.util.collections.CaseInsensitiveKeyMap$EntrySet");
        loader.loadClass("com.tongweb.web.util.collections.CaseInsensitiveKeyMap$Key");
        loader.loadClass("com.tongweb.web.util.http.CookieProcessor");
        loader.loadClass("com.tongweb.web.util.http.NamesEnumerator");
        Class<?> clazz = loader.loadClass("com.tongweb.web.util.http.FastHttpDateFormat");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        loader.loadClass("com.tongweb.web.util.http.parser.HttpParser");
        loader.loadClass("com.tongweb.web.util.http.parser.MediaType");
        loader.loadClass("com.tongweb.web.util.http.parser.MediaTypeCache");
        loader.loadClass("com.tongweb.web.util.http.parser.SkipResult");
        loader.loadClass("com.tongweb.web.util.net.Constants");
        loader.loadClass("com.tongweb.web.util.net.DispatchType");
        loader.loadClass("com.tongweb.web.util.net.AprEndpoint$AprSocketWrapper$AprOperationState");
        loader.loadClass("com.tongweb.web.util.net.NioEndpoint$NioSocketWrapper$NioOperationState");
        loader.loadClass("com.tongweb.web.util.net.Nio2Endpoint$Nio2SocketWrapper$Nio2OperationState");
        loader.loadClass("com.tongweb.web.util.net.SocketWrapperBase$BlockingMode");
        loader.loadClass("com.tongweb.web.util.net.SocketWrapperBase$CompletionCheck");
        loader.loadClass("com.tongweb.web.util.net.SocketWrapperBase$CompletionHandlerCall");
        loader.loadClass("com.tongweb.web.util.net.SocketWrapperBase$CompletionState");
        loader.loadClass("com.tongweb.web.util.net.SocketWrapperBase$VectoredIOCompletionHandler");
        loader.loadClass("com.tongweb.web.util.net.TLSClientHelloExtractor");
        loader.loadClass("com.tongweb.web.util.net.TLSClientHelloExtractor$ExtractorResult");
        loader.loadClass("com.tongweb.web.util.security.PrivilegedGetTccl");
        loader.loadClass("com.tongweb.web.util.security.PrivilegedSetTccl");
    }
}

