/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.ssi;

import com.tongweb.container.ssi.SSICommand;
import com.tongweb.container.ssi.SSIInclude;
import com.tongweb.container.ssi.SSIMediator;
import com.tongweb.container.util.IOTools;
import com.tongweb.web.util.res.StringManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class SSIExec
implements SSICommand {
    private static final StringManager sm = StringManager.getManager(SSIExec.class);
    protected final SSIInclude ssiInclude = new SSIInclude();
    protected static final int BUFFER_SIZE = 1024;

    @Override
    public long process(SSIMediator ssiMediator, String commandName, String[] paramNames, String[] paramValues, PrintWriter writer) {
        long lastModified = 0L;
        String configErrMsg = ssiMediator.getConfigErrMsg();
        String paramName = paramNames[0];
        String paramValue = paramValues[0];
        String substitutedValue = ssiMediator.substituteVariables(paramValue);
        if (paramName.equalsIgnoreCase("cgi")) {
            lastModified = this.ssiInclude.process(ssiMediator, "include", new String[]{"virtual"}, new String[]{substitutedValue}, writer);
        } else if (paramName.equalsIgnoreCase("cmd")) {
            boolean foundProgram = false;
            try {
                Runtime rt = Runtime.getRuntime();
                Process proc = rt.exec(substitutedValue);
                foundProgram = true;
                BufferedReader stdOutReader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader stdErrReader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                char[] buf = new char[1024];
                IOTools.flow(stdErrReader, writer, buf);
                IOTools.flow(stdOutReader, writer, buf);
                proc.waitFor();
                lastModified = System.currentTimeMillis();
            }
            catch (InterruptedException e2) {
                ssiMediator.log(sm.getString("ssiExec.executeFailed", substitutedValue), e2);
                writer.write(configErrMsg);
            }
            catch (IOException e3) {
                if (!foundProgram) {
                    // empty if block
                }
                ssiMediator.log(sm.getString("ssiExec.executeFailed", substitutedValue), e3);
            }
        }
        return lastModified;
    }
}

