/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.startup;

import com.tongweb.web.util.buf.UriUtil;
import com.tongweb.web.util.file.ConfigurationSource;
import com.tongweb.web.util.res.StringManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class CatalinaBaseConfigurationSource
implements ConfigurationSource {
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.startup");
    private final String serverXmlPath;
    private final File catalinaBaseFile;
    private final URI catalinaBaseUri;

    public CatalinaBaseConfigurationSource(File catalinaBaseFile, String serverXmlPath) {
        this.catalinaBaseFile = catalinaBaseFile;
        this.catalinaBaseUri = catalinaBaseFile.toURI();
        this.serverXmlPath = serverXmlPath;
    }

    @Override
    public ConfigurationSource.Resource getServerXml() throws IOException {
        InputStream stream;
        IOException ioe = null;
        ConfigurationSource.Resource result = null;
        try {
            result = this.serverXmlPath == null || this.serverXmlPath.equals("conf/server.xml") ? ConfigurationSource.super.getServerXml() : this.getResource(this.serverXmlPath);
        }
        catch (IOException e2) {
            ioe = e2;
        }
        if (result == null && (stream = this.getClass().getClassLoader().getResourceAsStream("server-embed.xml")) != null) {
            try {
                result = new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource("server-embed.xml").toURI());
            }
            catch (URISyntaxException e3) {
                stream.close();
            }
        }
        if (result == null && ioe != null) {
            throw ioe;
        }
        return result;
    }

    @Override
    public ConfigurationSource.Resource getResource(String name) throws IOException {
        if (!UriUtil.isAbsoluteURI(name)) {
            File f2 = new File(name);
            if (!f2.isAbsolute()) {
                f2 = new File(this.catalinaBaseFile, name);
            }
            if (f2.isFile()) {
                FileInputStream fis = new FileInputStream(f2);
                return new ConfigurationSource.Resource(fis, f2.toURI());
            }
            InputStream stream = null;
            try {
                stream = this.getClass().getClassLoader().getResourceAsStream(name);
                if (stream != null) {
                    return new ConfigurationSource.Resource(stream, this.getClass().getClassLoader().getResource(name).toURI());
                }
            }
            catch (URISyntaxException e2) {
                stream.close();
                throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name), e2);
            }
        }
        URI uri = null;
        try {
            uri = this.getURIInternal(name);
        }
        catch (IllegalArgumentException e3) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name));
        }
        try {
            URL url = uri.toURL();
            return new ConfigurationSource.Resource(url.openConnection().getInputStream(), uri);
        }
        catch (MalformedURLException e4) {
            throw new IOException(sm.getString("catalinaConfigurationSource.cannotObtainURL", name), e4);
        }
    }

    @Override
    public URI getURI(String name) {
        if (!UriUtil.isAbsoluteURI(name)) {
            File f2 = new File(name);
            if (!f2.isAbsolute()) {
                f2 = new File(this.catalinaBaseFile, name);
            }
            if (f2.isFile()) {
                return f2.toURI();
            }
            try {
                URL resource = this.getClass().getClassLoader().getResource(name);
                if (resource != null) {
                    return resource.toURI();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getURIInternal(name);
    }

    private URI getURIInternal(String name) {
        URI uri = this.catalinaBaseUri != null ? this.catalinaBaseUri.resolve(name) : URI.create(name);
        return uri;
    }
}

