/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.startup;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Server;
import com.tongweb.container.util.ServerInfo;
import com.tongweb.web.util.res.StringManager;
import java.lang.management.ManagementFactory;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class VersionLoggerListener
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(VersionLoggerListener.class);
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.startup");
    private boolean logArgs = true;
    private boolean logEnv = false;
    private boolean logProps = false;

    public boolean getLogArgs() {
        return this.logArgs;
    }

    public void setLogArgs(boolean logArgs) {
        this.logArgs = logArgs;
    }

    public boolean getLogEnv() {
        return this.logEnv;
    }

    public void setLogEnv(boolean logEnv) {
        this.logEnv = logEnv;
    }

    public boolean getLogProps() {
        return this.logProps;
    }

    public void setLogProps(boolean logProps) {
        this.logProps = logProps;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_init".equals(event.getType())) {
            if (!(event.getLifecycle() instanceof Server)) {
                log.warn(sm.getString("listener.notServer", event.getLifecycle().getClass().getSimpleName()));
            }
            this.log();
        }
    }

    private void log() {
        TreeMap<String, String> sortedMap;
        log.info(sm.getString("versionLoggerListener.serverInfo.server.version", ServerInfo.getServerInfo()));
        log.info(sm.getString("versionLoggerListener.serverInfo.server.built", ServerInfo.getServerBuilt()));
        log.info(sm.getString("versionLoggerListener.serverInfo.server.number", ServerInfo.getServerNumber()));
        log.info(sm.getString("versionLoggerListener.os.name", System.getProperty("os.name")));
        log.info(sm.getString("versionLoggerListener.os.version", System.getProperty("os.version")));
        log.info(sm.getString("versionLoggerListener.os.arch", System.getProperty("os.arch")));
        log.info(sm.getString("versionLoggerListener.java.home", System.getProperty("java.home")));
        log.info(sm.getString("versionLoggerListener.vm.version", System.getProperty("java.runtime.version")));
        log.info(sm.getString("versionLoggerListener.vm.vendor", System.getProperty("java.vm.vendor")));
        log.info(sm.getString("versionLoggerListener.catalina.base", System.getProperty("catalina.base")));
        log.info(sm.getString("versionLoggerListener.catalina.home", System.getProperty("catalina.home")));
        if (this.logArgs) {
            List<String> args = ManagementFactory.getRuntimeMXBean().getInputArguments();
            for (String string : args) {
                log.info(sm.getString("versionLoggerListener.arg", string));
            }
        }
        if (this.logEnv) {
            sortedMap = new TreeMap<String, String>(System.getenv());
            for (Map.Entry entry : sortedMap.entrySet()) {
                log.info(sm.getString("versionLoggerListener.env", entry.getKey(), entry.getValue()));
            }
        }
        if (this.logProps) {
            sortedMap = new TreeMap();
            for (Map.Entry entry : System.getProperties().entrySet()) {
                sortedMap.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
            }
            for (Map.Entry entry : sortedMap.entrySet()) {
                log.info(sm.getString("versionLoggerListener.prop", entry.getKey(), entry.getValue()));
            }
        }
    }
}

