/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreFactoryBase;
import com.tongweb.container.tribes.ChannelInterceptor;
import com.tongweb.container.tribes.group.interceptors.StaticMembershipInterceptor;
import java.io.PrintWriter;

public class InterceptorSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(InterceptorSF.class);

    @Override
    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        if (aElement instanceof StaticMembershipInterceptor) {
            StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
            if (elementDesc != null) {
                if (log.isDebugEnabled()) {
                    log.debug(sm.getString("factory.storeTag", elementDesc.getTag(), aElement));
                }
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printOpenTag(aWriter, indent + 2, aElement, elementDesc);
                this.storeChildren(aWriter, indent + 2, aElement, elementDesc);
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printCloseTag(aWriter, elementDesc);
            } else if (log.isWarnEnabled()) {
                log.warn(sm.getString("factory.storeNoDescriptor", aElement.getClass()));
            }
        } else {
            super.store(aWriter, indent, aElement);
        }
    }

    @Override
    public void storeChildren(PrintWriter aWriter, int indent, Object aInterceptor, StoreDescription parentDesc) throws Exception {
        if (aInterceptor instanceof StaticMembershipInterceptor) {
            ChannelInterceptor interceptor = (ChannelInterceptor)aInterceptor;
            this.storeElementArray(aWriter, indent + 2, interceptor.getMembers());
        }
    }
}

