/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.Loader;
import com.tongweb.container.loader.WebappLoader;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreFactoryBase;
import java.io.PrintWriter;

public class LoaderSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(LoaderSF.class);

    @Override
    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
        if (elementDesc != null) {
            Loader loader = (Loader)aElement;
            if (!this.isDefaultLoader(loader)) {
                if (log.isDebugEnabled()) {
                    log.debug("store " + elementDesc.getTag() + "( " + aElement + " )");
                }
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printTag(aWriter, indent + 2, loader, elementDesc);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Descriptor for element" + aElement.getClass() + " not configured or element class not StandardManager!");
        }
    }

    protected boolean isDefaultLoader(Loader loader) {
        if (!(loader instanceof WebappLoader)) {
            return false;
        }
        WebappLoader wloader = (WebappLoader)loader;
        return !wloader.getDelegate() && wloader.getLoaderClass().equals("com.tongweb.container.loader.WebappClassLoader");
    }
}

