/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.LifecycleEvent;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Server;
import com.tongweb.container.mbeans.MBeanUtils;
import com.tongweb.container.storeconfig.IStoreConfig;
import com.tongweb.container.storeconfig.StoreLoader;
import com.tongweb.web.util.modeler.ManagedBean;
import com.tongweb.web.util.modeler.Registry;
import com.tongweb.web.util.res.StringManager;
import javax.management.DynamicMBean;
import javax.management.ObjectName;

public class StoreConfigLifecycleListener
implements LifecycleListener {
    private static Log log = LogFactory.getLog(StoreConfigLifecycleListener.class);
    private static StringManager sm = StringManager.getManager(StoreConfigLifecycleListener.class);
    protected final Registry registry = MBeanUtils.createRegistry();
    IStoreConfig storeConfig;
    private String storeConfigClass = "com.tongweb.container.storeconfig.StoreConfig";
    private String storeRegistry = null;
    private ObjectName oname = null;

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("after_start".equals(event.getType())) {
            if (event.getSource() instanceof Server) {
                this.createMBean((Server)event.getSource());
            } else {
                log.warn(sm.getString("storeConfigListener.notServer", event.getLifecycle().getClass().getSimpleName()));
            }
        } else if ("after_stop".equals(event.getType()) && this.oname != null) {
            this.registry.unregisterComponent(this.oname);
            this.oname = null;
        }
    }

    protected void createMBean(Server server) {
        StoreLoader loader = new StoreLoader();
        try {
            Class<?> clazz = Class.forName(this.getStoreConfigClass(), true, this.getClass().getClassLoader());
            this.storeConfig = (IStoreConfig)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            loader.load(this.getStoreRegistry());
            this.storeConfig.setRegistry(loader.getRegistry());
            this.storeConfig.setServer(server);
        }
        catch (Exception e2) {
            log.error(sm.getString("storeConfigListener.loadError"), e2);
            return;
        }
        try {
            this.oname = new ObjectName("Catalina:type=StoreConfig");
            this.registry.registerComponent((Object)this.storeConfig, this.oname, "StoreConfig");
        }
        catch (Exception ex) {
            log.error(sm.getString("storeConfigListener.registerError"), ex);
        }
    }

    protected DynamicMBean getManagedBean(Object object) throws Exception {
        ManagedBean managedBean = this.registry.findManagedBean("StoreConfig");
        return managedBean.createMBean(object);
    }

    public IStoreConfig getStoreConfig() {
        return this.storeConfig;
    }

    public void setStoreConfig(IStoreConfig storeConfig) {
        this.storeConfig = storeConfig;
    }

    public String getStoreConfigClass() {
        return this.storeConfigClass;
    }

    public void setStoreConfigClass(String storeConfigClass) {
        this.storeConfigClass = storeConfigClass;
    }

    public String getStoreRegistry() {
        return this.storeRegistry;
    }

    public void setStoreRegistry(String storeRegistry) {
        this.storeRegistry = storeRegistry;
    }
}

