/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.storeconfig.IStoreFactory;
import com.tongweb.container.storeconfig.StoreAppender;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.storeconfig.StoreRegistry;
import com.tongweb.web.util.res.StringManager;
import java.io.IOException;
import java.io.PrintWriter;

public class StoreFactoryBase
implements IStoreFactory {
    private static Log log = LogFactory.getLog(StoreFactoryBase.class);
    private StoreRegistry registry;
    private StoreAppender storeAppender = new StoreAppender();
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.storeconfig");
    private static final String info = "com.tongweb.container.config.StoreFactoryBase/1.0";

    public String getInfo() {
        return info;
    }

    @Override
    public StoreAppender getStoreAppender() {
        return this.storeAppender;
    }

    @Override
    public void setStoreAppender(StoreAppender storeAppender) {
        this.storeAppender = storeAppender;
    }

    @Override
    public void setRegistry(StoreRegistry aRegistry) {
        this.registry = aRegistry;
    }

    @Override
    public StoreRegistry getRegistry() {
        return this.registry;
    }

    @Override
    public void storeXMLHead(PrintWriter aWriter) {
        aWriter.print("<?xml version=\"1.0\" encoding=\"");
        aWriter.print(this.getRegistry().getEncoding());
        aWriter.println("\"?>");
    }

    @Override
    public void store(PrintWriter aWriter, int indent, Object aElement) throws Exception {
        StoreDescription elementDesc = this.getRegistry().findDescription(aElement.getClass());
        if (elementDesc != null) {
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("factory.storeTag", elementDesc.getTag(), aElement));
            }
            this.getStoreAppender().printIndent(aWriter, indent + 2);
            if (!elementDesc.isChildren()) {
                this.getStoreAppender().printTag(aWriter, indent, aElement, elementDesc);
            } else {
                this.getStoreAppender().printOpenTag(aWriter, indent + 2, aElement, elementDesc);
                this.storeChildren(aWriter, indent + 2, aElement, elementDesc);
                this.getStoreAppender().printIndent(aWriter, indent + 2);
                this.getStoreAppender().printCloseTag(aWriter, elementDesc);
            }
        } else {
            log.warn(sm.getString("factory.storeNoDescriptor", aElement.getClass()));
        }
    }

    public void storeChildren(PrintWriter aWriter, int indent, Object aElement, StoreDescription elementDesc) throws Exception {
    }

    protected void storeElement(PrintWriter aWriter, int indent, Object aTagElement) throws Exception {
        if (aTagElement != null) {
            IStoreFactory elementFactory = this.getRegistry().findStoreFactory(aTagElement.getClass());
            if (elementFactory != null) {
                StoreDescription desc = this.getRegistry().findDescription(aTagElement.getClass());
                if (!desc.isTransientChild(aTagElement.getClass().getName())) {
                    elementFactory.store(aWriter, indent, aTagElement);
                }
            } else {
                log.warn(sm.getString("factory.storeNoDescriptor", aTagElement.getClass()));
            }
        }
    }

    protected void storeElementArray(PrintWriter aWriter, int indent, Object[] elements) throws Exception {
        if (elements != null) {
            for (Object element : elements) {
                try {
                    this.storeElement(aWriter, indent, element);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

