/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.container.storeconfig.StoreFactoryRule;
import com.tongweb.container.storeconfig.StoreRegistry;
import com.tongweb.web.util.digester.Digester;
import com.tongweb.web.util.file.ConfigFileLoader;
import com.tongweb.web.util.file.ConfigurationSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class StoreLoader {
    protected static final Digester digester = StoreLoader.createDigester();
    private StoreRegistry registry;
    private URL registryResource;

    public StoreRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(StoreRegistry registry) {
        this.registry = registry;
    }

    protected static Digester createDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setClassLoader(StoreRegistry.class.getClassLoader());
        digester.addObjectCreate("Registry", "com.tongweb.container.storeconfig.StoreRegistry", "className");
        digester.addSetProperties("Registry");
        digester.addObjectCreate("Registry/Description", "com.tongweb.container.storeconfig.StoreDescription", "className");
        digester.addSetProperties("Registry/Description");
        digester.addRule("Registry/Description", new StoreFactoryRule("com.tongweb.container.storeconfig.StoreFactoryBase", "storeFactoryClass", "com.tongweb.container.storeconfig.StoreAppender", "storeAppenderClass"));
        digester.addSetNext("Registry/Description", "registerDescription", "com.tongweb.container.storeconfig.StoreDescription");
        digester.addCallMethod("Registry/Description/TransientAttribute", "addTransientAttribute", 0);
        digester.addCallMethod("Registry/Description/TransientChild", "addTransientChild", 0);
        return digester;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String path) throws Exception {
        try (ConfigurationSource.Resource resource = path == null ? ConfigFileLoader.getSource().getConfResource("server-registry.xml") : ConfigFileLoader.getSource().getResource(path);
             InputStream is = resource.getInputStream();){
            this.registryResource = resource.getURI().toURL();
            Digester digester = StoreLoader.digester;
            synchronized (digester) {
                this.registry = (StoreRegistry)StoreLoader.digester.parse(is);
            }
        }
        catch (IOException e2) {
            try (InputStream is2 = StoreLoader.class.getResourceAsStream("/com/tongweb/container/storeconfig/server-registry.xml");){
                if (is2 != null) {
                    this.registryResource = StoreLoader.class.getResource("/com/tongweb/container/storeconfig/server-registry.xml");
                    Digester digester = StoreLoader.digester;
                    synchronized (digester) {
                        this.registry = (StoreRegistry)StoreLoader.digester.parse(is2);
                    }
                }
                throw e2;
            }
        }
    }

    public URL getRegistryResource() {
        return this.registryResource;
    }
}

