/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.storeconfig;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.connector.UpgradeProtocol;
import com.tongweb.container.CredentialHandler;
import com.tongweb.container.LifecycleListener;
import com.tongweb.container.Manager;
import com.tongweb.container.Realm;
import com.tongweb.container.Valve;
import com.tongweb.container.WebResourceRoot;
import com.tongweb.container.WebResourceSet;
import com.tongweb.container.ha.CatalinaCluster;
import com.tongweb.container.ha.ClusterDeployer;
import com.tongweb.container.ha.ClusterListener;
import com.tongweb.container.storeconfig.IStoreFactory;
import com.tongweb.container.storeconfig.StoreDescription;
import com.tongweb.container.tribes.Channel;
import com.tongweb.container.tribes.ChannelInterceptor;
import com.tongweb.container.tribes.ChannelReceiver;
import com.tongweb.container.tribes.ChannelSender;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.MembershipService;
import com.tongweb.container.tribes.MessageListener;
import com.tongweb.container.tribes.transport.DataSender;
import com.tongweb.web.util.http.CookieProcessor;
import com.tongweb.web.util.res.StringManager;
import java.util.HashMap;
import java.util.Map;
import javax.naming.directory.DirContext;

public class StoreRegistry {
    private static Log log = LogFactory.getLog(StoreRegistry.class);
    private static StringManager sm = StringManager.getManager(StoreRegistry.class);
    private Map<String, StoreDescription> descriptors = new HashMap<String, StoreDescription>();
    private String encoding = "UTF-8";
    private String name;
    private String version;
    private static Class<?>[] interfaces = new Class[]{CatalinaCluster.class, ChannelSender.class, ChannelReceiver.class, Channel.class, MembershipService.class, ClusterDeployer.class, Realm.class, Manager.class, DirContext.class, LifecycleListener.class, Valve.class, ClusterListener.class, MessageListener.class, DataSender.class, ChannelInterceptor.class, Member.class, WebResourceRoot.class, WebResourceSet.class, CredentialHandler.class, UpgradeProtocol.class, CookieProcessor.class};

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public StoreDescription findDescription(String id) {
        StoreDescription desc;
        if (log.isDebugEnabled()) {
            log.debug("search descriptor " + id);
        }
        if ((desc = this.descriptors.get(id)) == null) {
            Class<?> aClass = null;
            try {
                aClass = Class.forName(id, true, this.getClass().getClassLoader());
            }
            catch (ClassNotFoundException e2) {
                log.error(sm.getString("registry.loadClassFailed", id), e2);
            }
            if (aClass != null) {
                desc = this.descriptors.get(aClass.getName());
                for (int i2 = 0; desc == null && i2 < interfaces.length; ++i2) {
                    if (!interfaces[i2].isAssignableFrom(aClass)) continue;
                    desc = this.descriptors.get(interfaces[i2].getName());
                }
            }
        }
        if (log.isDebugEnabled()) {
            if (desc != null) {
                log.debug("find descriptor " + id + "#" + desc.getTag() + "#" + desc.getStoreFactoryClass());
            } else {
                log.debug("Can't find descriptor for key " + id);
            }
        }
        return desc;
    }

    public StoreDescription findDescription(Class<?> aClass) {
        return this.findDescription(aClass.getName());
    }

    public IStoreFactory findStoreFactory(String aClassName) {
        StoreDescription desc = this.findDescription(aClassName);
        if (desc != null) {
            return desc.getStoreFactory();
        }
        return null;
    }

    public IStoreFactory findStoreFactory(Class<?> aClass) {
        return this.findStoreFactory(aClass.getName());
    }

    public void registerDescription(StoreDescription desc) {
        String key = desc.getId();
        if (key == null || key.isEmpty()) {
            key = desc.getTagClass();
        }
        this.descriptors.put(key, desc);
        if (log.isDebugEnabled()) {
            log.debug("register store descriptor " + key + "#" + desc.getTag() + "#" + desc.getTagClass());
        }
    }

    public StoreDescription unregisterDescription(StoreDescription desc) {
        String key = desc.getId();
        if (key == null || "".equals(key)) {
            key = desc.getTagClass();
        }
        return this.descriptors.remove(key);
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }
}

