/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.membership;

import com.tongweb.container.tribes.Channel;
import com.tongweb.container.tribes.ChannelException;
import com.tongweb.container.tribes.ChannelMessage;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.MembershipListener;
import com.tongweb.container.tribes.MembershipService;
import com.tongweb.container.tribes.membership.Membership;
import java.util.Properties;

public abstract class MembershipServiceBase
implements MembershipService,
MembershipListener {
    protected Properties properties = new Properties();
    protected volatile MembershipListener listener;
    protected Channel channel;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean hasMembers() {
        if (this.getMembershipProvider() == null) {
            return false;
        }
        return this.getMembershipProvider().hasMembers();
    }

    @Override
    public Member getMember(Member mbr) {
        if (this.getMembershipProvider() == null) {
            return null;
        }
        return this.getMembershipProvider().getMember(mbr);
    }

    @Override
    public Member[] getMembers() {
        if (this.getMembershipProvider() == null) {
            return Membership.EMPTY_MEMBERS;
        }
        return this.getMembershipProvider().getMembers();
    }

    @Override
    public String[] getMembersByName() {
        String[] membernames;
        Member[] currentMembers = this.getMembers();
        if (currentMembers != null) {
            membernames = new String[currentMembers.length];
            for (int i2 = 0; i2 < currentMembers.length; ++i2) {
                membernames[i2] = currentMembers[i2].toString();
            }
        } else {
            membernames = new String[]{};
        }
        return membernames;
    }

    @Override
    public Member findMemberByName(String name) {
        Member[] currentMembers;
        for (Member currentMember : currentMembers = this.getMembers()) {
            if (!name.equals(currentMember.toString())) continue;
            return currentMember;
        }
        return null;
    }

    @Override
    public void setMembershipListener(MembershipListener listener) {
        this.listener = listener;
    }

    @Override
    public void removeMembershipListener() {
        this.listener = null;
    }

    @Override
    public void memberAdded(Member member) {
        MembershipListener listener = this.listener;
        if (listener != null) {
            listener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        MembershipListener listener = this.listener;
        if (listener != null) {
            listener.memberDisappeared(member);
        }
    }

    @Override
    public void broadcast(ChannelMessage message) throws ChannelException {
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    @Override
    public void start() throws Exception {
        this.start(4);
        this.start(8);
    }
}

