/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.membership.cloud;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.membership.MemberImpl;
import com.tongweb.container.tribes.membership.cloud.CloudMembershipProvider;
import com.tongweb.container.tribes.membership.cloud.CloudMembershipService;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;

public class DNSMembershipProvider
extends CloudMembershipProvider {
    private static final Log log = LogFactory.getLog(DNSMembershipProvider.class);
    private String dnsServiceName;

    @Override
    public void start(int level) throws Exception {
        if ((level & 4) == 0) {
            return;
        }
        super.start(level);
        this.dnsServiceName = DNSMembershipProvider.getEnv("DNS_MEMBERSHIP_SERVICE_NAME");
        if (this.dnsServiceName == null) {
            this.dnsServiceName = this.getNamespace();
        }
        if (log.isDebugEnabled()) {
            log.debug(String.format("Namespace [%s] set; clustering enabled", this.dnsServiceName));
        }
        this.dnsServiceName = URLEncoder.encode(this.dnsServiceName, "UTF-8");
        this.heartbeat();
    }

    @Override
    public boolean stop(int level) throws Exception {
        return super.stop(level);
    }

    @Override
    protected Member[] fetchMembers() {
        ArrayList<MemberImpl> members = new ArrayList<MemberImpl>();
        InetAddress[] inetAddresses = null;
        try {
            inetAddresses = InetAddress.getAllByName(this.dnsServiceName);
        }
        catch (UnknownHostException exception) {
            log.warn(sm.getString("dnsMembershipProvider.dnsError", this.dnsServiceName), exception);
        }
        if (inetAddresses != null) {
            for (InetAddress inetAddress : inetAddresses) {
                String ip = inetAddress.getHostAddress();
                byte[] id = this.md5.digest(ip.getBytes());
                if (ip.equals(this.localIp)) {
                    Member localMember = this.service.getLocalMember(false);
                    if (localMember.getUniqueId() != CloudMembershipService.INITIAL_ID || !(localMember instanceof MemberImpl)) continue;
                    ((MemberImpl)localMember).setUniqueId(id);
                    continue;
                }
                long aliveTime = -1L;
                MemberImpl member = null;
                try {
                    member = new MemberImpl(ip, this.port, aliveTime);
                }
                catch (IOException e2) {
                    log.error(sm.getString("kubernetesMembershipProvider.memberError"), e2);
                    continue;
                }
                member.setUniqueId(id);
                members.add(member);
            }
        }
        return members.toArray(new Member[0]);
    }

    @Override
    public boolean accept(Serializable msg, Member sender) {
        boolean found = false;
        Member[] members = this.membership.getMembers();
        if (members != null) {
            for (Member member : members) {
                if (!Arrays.equals(sender.getHost(), member.getHost()) || sender.getPort() != member.getPort()) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            MemberImpl member = new MemberImpl();
            member.setHost(sender.getHost());
            member.setPort(sender.getPort());
            byte[] host = sender.getHost();
            int i2 = 0;
            StringBuilder buf = new StringBuilder();
            buf.append(host[i2++] & 0xFF);
            while (i2 < host.length) {
                buf.append(".").append(host[i2] & 0xFF);
                ++i2;
            }
            byte[] id = this.md5.digest(buf.toString().getBytes());
            member.setUniqueId(id);
            member.setMemberAliveTime(-1L);
            this.updateMember(member, true);
        }
        return false;
    }
}

