/*
 * Decompiled with CFR 0.152.
 */
package com.tongweb.container.tribes.transport;

import com.tongweb.commons.logger.logging.Log;
import com.tongweb.commons.logger.logging.LogFactory;
import com.tongweb.container.tribes.Member;
import com.tongweb.container.tribes.transport.AbstractSender;
import com.tongweb.container.tribes.transport.DataSender;
import com.tongweb.container.tribes.transport.MultiPointSender;
import com.tongweb.container.tribes.util.StringManager;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public abstract class PooledSender
extends AbstractSender
implements MultiPointSender {
    private static final Log log = LogFactory.getLog(PooledSender.class);
    protected static final StringManager sm = StringManager.getManager("com.tongweb.container.tribes.transport");
    private final SenderQueue queue = new SenderQueue(this, this.poolSize);
    private int poolSize = 25;
    private long maxWait = 3000L;

    public abstract DataSender getNewDataSender();

    public DataSender getSender() {
        return this.queue.getSender(this.getMaxWait());
    }

    public void returnSender(DataSender sender) {
        sender.keepalive();
        this.queue.returnSender(sender);
    }

    @Override
    public synchronized void connect() throws IOException {
        this.queue.open();
        this.setConnected(true);
    }

    @Override
    public synchronized void disconnect() {
        this.queue.close();
        this.setConnected(false);
    }

    public int getInPoolSize() {
        return this.queue.getInPoolSize();
    }

    public int getInUsePoolSize() {
        return this.queue.getInUsePoolSize();
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
        this.queue.setLimit(poolSize);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public long getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(long maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public boolean keepalive() {
        return this.queue == null ? false : this.queue.checkIdleKeepAlive();
    }

    @Override
    public void add(Member member) {
    }

    @Override
    public void remove(Member member) {
    }

    private static class SenderQueue {
        private int limit = 25;
        PooledSender parent = null;
        private List<DataSender> notinuse = null;
        private List<DataSender> inuse = null;
        private boolean isOpen = true;

        public SenderQueue(PooledSender parent, int limit) {
            this.limit = limit;
            this.parent = parent;
            this.notinuse = new LinkedList<DataSender>();
            this.inuse = new LinkedList<DataSender>();
        }

        public int getLimit() {
            return this.limit;
        }

        public void setLimit(int limit) {
            this.limit = limit;
        }

        public int getInUsePoolSize() {
            return this.inuse.size();
        }

        public int getInPoolSize() {
            return this.notinuse.size();
        }

        public synchronized boolean checkIdleKeepAlive() {
            DataSender[] list = new DataSender[this.notinuse.size()];
            this.notinuse.toArray(list);
            boolean result = false;
            for (DataSender dataSender : list) {
                result |= dataSender.keepalive();
            }
            return result;
        }

        public synchronized DataSender getSender(long timeout) {
            long start = System.currentTimeMillis();
            while (true) {
                if (!this.isOpen) {
                    throw new IllegalStateException(sm.getString("pooledSender.closed.queue"));
                }
                DataSender sender = null;
                if (this.notinuse.size() == 0 && this.inuse.size() < this.limit) {
                    sender = this.parent.getNewDataSender();
                } else if (this.notinuse.size() > 0) {
                    sender = this.notinuse.remove(0);
                }
                if (sender != null) {
                    this.inuse.add(sender);
                    return sender;
                }
                long delta = System.currentTimeMillis() - start;
                if (delta > timeout && timeout > 0L) {
                    return null;
                }
                try {
                    this.wait(Math.max(timeout - delta, 1L));
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }

        public synchronized void returnSender(DataSender sender) {
            block5: {
                if (!this.isOpen) {
                    sender.disconnect();
                    return;
                }
                this.inuse.remove(sender);
                if (this.notinuse.size() < this.getLimit()) {
                    this.notinuse.add(sender);
                } else {
                    try {
                        sender.disconnect();
                    }
                    catch (Exception e2) {
                        if (!log.isDebugEnabled()) break block5;
                        log.debug(sm.getString("PooledSender.senderDisconnectFail"), e2);
                    }
                }
            }
            this.notifyAll();
        }

        public synchronized void close() {
            DataSender sender;
            this.isOpen = false;
            Object[] unused = this.notinuse.toArray();
            Object[] used = this.inuse.toArray();
            for (Object value : unused) {
                sender = (DataSender)value;
                sender.disconnect();
            }
            for (Object o : used) {
                sender = (DataSender)o;
                sender.disconnect();
            }
            this.notinuse.clear();
            this.inuse.clear();
            this.notifyAll();
        }

        public synchronized void open() {
            this.isOpen = true;
            this.notifyAll();
        }
    }
}

